<?php
/* Copyright (C) 2004-2017 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2019 SuperAdmin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file    fichajes/admin/setup.php
 * \ingroup fichajes
 * \brief   Fichajes setup page.
 */

// Load Dolibarr environment
$res = 0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (!$res && !empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) {
    $res = @include $_SERVER["CONTEXT_DOCUMENT_ROOT"] . "/main.inc.php";
}

// Try main.inc.php into web root detected using web root calculated from SCRIPT_FILENAME
$tmp = empty($_SERVER['SCRIPT_FILENAME']) ? '' : $_SERVER['SCRIPT_FILENAME'];
$tmp2 = realpath(__FILE__);
$i = strlen($tmp) - 1;
$j = strlen($tmp2) - 1;
while ($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i] == $tmp2[$j]) {$i--;
    $j--;}
if (!$res && $i > 0 && file_exists(substr($tmp, 0, ($i + 1)) . "/main.inc.php")) {
    $res = @include substr($tmp, 0, ($i + 1)) . "/main.inc.php";
}

if (!$res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i + 1))) . "/main.inc.php")) {
    $res = @include dirname(substr($tmp, 0, ($i + 1))) . "/main.inc.php";
}

// Try main.inc.php using relative path
if (!$res && file_exists("../../main.inc.php")) {
    $res = @include "../../main.inc.php";
}

if (!$res && file_exists("../../../main.inc.php")) {
    $res = @include "../../../main.inc.php";
}

if (!$res) {
    die("Include of main fails");
}

global $langs, $user;

// Libraries
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
require_once '../lib/fichajes.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';

// Translations
$langs->load("admin");
$langs->load("fichajes@fichajes");

// Access control
if (!$user->admin) {
    accessforbidden();
}

// Parameters
$action = GETPOST('action', 'alpha');
$backtopage = GETPOST('backtopage', 'alpha');

$timetable = array();

/*
 * Actions
 */
if ((float) DOL_VERSION >= 6) {
    include DOL_DOCUMENT_ROOT . '/core/actions_setmoduleoptions.inc.php';
}

if ($action == "setautofichajeentrada") {
    $activado = GETPOST('value', 'int');
    $res = dolibarr_set_const($db, "FICHAJES_AUTO_FICHAJE_ENTRADA", $activado, 'yesno', 1, '', 0);
    if (!$res > 0) {
        $error++;
    }

    if (!$error) {
        setEventMessages($langs->trans("SetupSaved"), null, 'mesgs');
    } else {
        setEventMessages($langs->trans("Error"), null, 'errors');
    }
} elseif ($action == "setautofichajesalida") {
    $activado = GETPOST('value', 'int');
    $res = dolibarr_set_const($db, "FICHAJES_AUTO_FICHAJE_SALIDA", $activado, 'yesno', 1, '', 0);
    if (!$res > 0) {
        $error++;
    }

    if (!$error) {
        setEventMessages($langs->trans("SetupSaved"), null, 'mesgs');
    } else {
        setEventMessages($langs->trans("Error"), null, 'errors');
    }
} elseif ($action == "setgeolocalizacion") {
    $activado = GETPOST('value', 'int');

    $res = dolibarr_set_const($db, "FICHAJES_GEOLOCALIZACION", $activado, 'yesno', 1, '', 0);
    if (!$res > 0) {
        $error++;
    }

    if (!$error) {
        setEventMessages($langs->trans("SetupSaved"), null, 'mesgs');
    } else {
        setEventMessages($langs->trans("Error"), null, 'errors');
    }
} elseif ($action == "setallowbreaks") {
    $activado = GETPOST('value', 'int');

    $res = dolibarr_set_const($db, "FICHAJES_PERMITIR_PAUSAS", $activado, 'yesno', 1, '', 0);
    if (!$res > 0) {
        $error++;
    }

    if (!$error) {
        setEventMessages($langs->trans("SetupSaved"), null, 'mesgs');
    } else {
        setEventMessages($langs->trans("Error"), null, 'errors');
    }
} elseif ($action == "setpauserequiresentry") {
    $activado = GETPOST('value', 'int');

    $res = dolibarr_set_const($db, "FICHAJES_PAUSA_REQUIERE_NUEVA_ENTRADA", $activado, 'yesno', 1, '', 0);
    if (!$res > 0) {
        $error++;
    }

    if (!$error) {
        setEventMessages($langs->trans("SetupSaved"), null, 'mesgs');
    } else {
        setEventMessages($langs->trans("Error"), null, 'errors');
    }
} elseif ($action == "setcomputeentrybeforeworkday") {
    $activado = GETPOST('value', 'int');

    $res = dolibarr_set_const($db, "FICHAJES_NO_COMPUTAR_ENTRADAS_ANTES_HORARIO_LABORAL", $activado, 'yesno', 1, '', 0);
    if (!$res > 0) {
        $error++;
    }

    if (!$error) {
        setEventMessages($langs->trans("SetupSaved"), null, 'mesgs');
    } else {
        setEventMessages($langs->trans("Error"), null, 'errors');
    }
} elseif ($action == "actualizarHorarios") {
	$weekdays = $_POST["timetable"];

    //print_r($weekdays);

	$d = 1;
    foreach ($weekdays as $weekday) {
        $sql = "";

        if (empty($weekday["entrytime"]) || empty($weekday["leavetime"])) {
            $sql = "UPDATE " . MAIN_DB_PREFIX . "fichajes_timetable SET entrytime = NULL, leavetime = NULL WHERE day = " . $d;
        } else {
            $sql = "UPDATE " . MAIN_DB_PREFIX . "fichajes_timetable SET entrytime = '" . $weekday["entrytime"] . "', leavetime = '" . $weekday["leavetime"] . "' WHERE day = " . $d;
        }
        
		$resql = $db->query($sql);
		$d++;
    }
}

/*
 * View
 */

$form = new Form($db);

$page_name = "FichajesSetup";
llxHeader('', $langs->trans($page_name));

// Subheader
$linkback = '<a href="' . ($backtopage ? $backtopage : DOL_URL_ROOT . '/admin/modules.php?restore_lastsearch_values=1') . '">' . $langs->trans("BackToModuleList") . '</a>';

print load_fiche_titre($langs->trans($page_name), $linkback, 'object_fichajes@fichajes');

// Configuration header
$head = fichajesAdminPrepareHead();
dol_fiche_head($head, 'settings', '', -1, "fichajes@fichajes");

// Setup page goes here

$sql = "SELECT ft.day, ft.entrytime, ft.leavetime FROM " . MAIN_DB_PREFIX . "fichajes_timetable ft";
$resql = $db->query($sql);
if ($resql) {
    $num = $db->num_rows($resql);
    $i = 0;
    while ($i < $num) {
		$obj = $db->fetch_object($resql);
		array_push($timetable, array("day" => $obj->day, "entrytime" => $obj->entrytime, "leavetime" => $obj->leavetime));
		$i++;
	}
}

if ($action == 'edit') {
    print '<form method="POST" action="' . $_SERVER["PHP_SELF"] . '">';
    print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
    print '<input type="hidden" name="action" value="actualizarHorarios">';

    print '<table class="noborder" width="100%">';
    print '<tr class="liste_titre"><td class="titlefield">' . $langs->trans("Horario") . '</td><td>' . $langs->trans("Lunes") . '</td><td>' . $langs->trans("Martes") . '</td><td>' . $langs->trans("Miercoles") . '</td><td>' . $langs->trans("Jueves") . '</td><td>' . $langs->trans("Viernes") . '</td><td>' . $langs->trans("Sabado") . '</td><td>' . $langs->trans("Domingo") . '</td></tr>';

    print '<tr class="oddeven"><td>Entrada</td>';

    foreach ($timetable as $val) {
        print "<td><input type='time' name='timetable[".$val["day"]."][entrytime]' class='flat minwidth200' value='" . $val["entrytime"] . "'></td>";
    }

    print '</tr><tr class="oddeven"><td>Salida</td>';

	foreach ($timetable as $val) {
        print "<td><input type='time' name='timetable[".$val["day"]."][leavetime]' class='flat minwidth200' value='" . $val["leavetime"] . "'></td>";
    }

    print '</tr></table>';

    print '<br><div class="right">';
    print '<input class="butAction" type="submit" value="' . $langs->trans("Save") . '">';
    print '</div>';

    print '</form>';
    print '<br>';

} else {
    print load_fiche_titre($langs->trans("HorariosEntradaSalida"), '', '');

    print '<table class="noborder" style="margin-bottom: 2rem" width="100%">';
    print '<tr class="liste_titre"><td class="titlefield">' . $langs->trans("Horario") . '</td><td>' . $langs->trans("Lunes") . '</td><td>' . $langs->trans("Martes") . '</td><td>' . $langs->trans("Miercoles") . '</td><td>' . $langs->trans("Jueves") . '</td><td>' . $langs->trans("Viernes") . '</td><td>' . $langs->trans("Sabado") . '</td><td>' . $langs->trans("Domingo") . '</td></tr>';

    print '<tr class="oddeven"><td>Entrada</td>';

    foreach ($timetable as $val) {
        print '<td>' . $val["entrytime"] . '</td>';
    }

    print '<tr class="oddeven"><td>Salida</td>';

    foreach ($timetable as $val) {
        print '<td>' . $val["leavetime"] . '</td>';
    }

    print '</table>';

    print '<div class="tabsAction">';
    print '<a class="butAction" href="' . $_SERVER["PHP_SELF"] . '?action=edit">' . $langs->trans("Modify") . '</a>';
    print '</div>';
}

print load_fiche_titre($langs->trans("OpcionesAdicionales"), '', '');
print '<table class="noborder" width="100%">';
// Autoentrada
print '<tr>';
print '<td>' . $langs->trans("AutoFichajeEntradaLogin") . '</td>';

if (!empty($conf->global->FICHAJES_AUTO_FICHAJE_ENTRADA)) {
    print '<td class="right"><a href="' . $_SERVER['PHP_SELF'] . '?action=setautofichajeentrada&value=0">';
    print img_picto($langs->trans("Activated"), 'switch_on');
} else {
    print '<td class="right"><a href="' . $_SERVER['PHP_SELF'] . '?action=setautofichajeentrada&value=1">';
    print img_picto($langs->trans("Disabled"), 'switch_off');
}
print '</a></td></tr>';

// Autosalida
print '<tr>';
print '<td>' . $langs->trans("AutoFichajeSalidaLogin") . '</td>';

if (!empty($conf->global->FICHAJES_AUTO_FICHAJE_SALIDA)) {
    print '<td class="right"><a href="' . $_SERVER['PHP_SELF'] . '?action=setautofichajesalida&value=0">';
    print img_picto($langs->trans("Activated"), 'switch_on');
} else {
    print '<td class="right"><a href="' . $_SERVER['PHP_SELF'] . '?action=setautofichajesalida&value=1">';
    print img_picto($langs->trans("Disabled"), 'switch_off');
}
print '</a></td></tr>';

// Geolocalización
print '<tr>';
print '<td>' . $langs->trans("Geolocalizacion") . '</td>';

if (!empty($conf->global->FICHAJES_GEOLOCALIZACION)) {
    print '<td class="right"><a href="' . $_SERVER['PHP_SELF'] . '?action=setgeolocalizacion&value=0">';
    print img_picto($langs->trans("Activated"), 'switch_on');
} else {
    print '<td class="right"><a href="' . $_SERVER['PHP_SELF'] . '?action=setgeolocalizacion&value=1">';
    print img_picto($langs->trans("Disabled"), 'switch_off');
}
print '</a></td></tr>';

// Permitir pausas
print '<tr>';
print '<td>' . $langs->trans("PermitirPausas") . '</td>';

if (!empty($conf->global->FICHAJES_PERMITIR_PAUSAS)) {
    print '<td class="right"><a href="' . $_SERVER['PHP_SELF'] . '?action=setallowbreaks&value=0">';
    print img_picto($langs->trans("Activated"), 'switch_on');
} else {
    print '<td class="right"><a href="' . $_SERVER['PHP_SELF'] . '?action=setallowbreaks&value=1">';
    print img_picto($langs->trans("Disabled"), 'switch_off');
}
print '</a></td></tr>';

// Cada pausa requiere una nueva entrada
if (!empty($conf->global->FICHAJES_PERMITIR_PAUSAS)) {
    // No mostrar esta config si no están habilitadas las pausas
    print '<tr>';
    print '<td>' . $langs->trans("PausaRequiereEntrada") . '</td>';
    
    if (!empty($conf->global->FICHAJES_PAUSA_REQUIERE_NUEVA_ENTRADA)) {
        print '<td class="right"><a href="' . $_SERVER['PHP_SELF'] . '?action=setpauserequiresentry&value=0">';
        print img_picto($langs->trans("Activated"), 'switch_on');
    } else {
        print '<td class="right"><a href="' . $_SERVER['PHP_SELF'] . '?action=setpauserequiresentry&value=1">';
        print img_picto($langs->trans("Disabled"), 'switch_off');
    }
    print '</a></td></tr>';
}

print '<tr><td>' . $langs->trans("NoComputarTiempoAntesEntradaJornadaLaboral") . '</td>';
if (!empty($conf->global->FICHAJES_NO_COMPUTAR_ENTRADAS_ANTES_HORARIO_LABORAL)) {
    print '<td class="right"><a href="' . $_SERVER['PHP_SELF'] . '?action=setcomputeentrybeforeworkday&value=0">';
    print img_picto($langs->trans("Activated"), 'switch_on');
} else {
    print '<td class="right"><a href="' . $_SERVER['PHP_SELF'] . '?action=setcomputeentrybeforeworkday&value=1">';
    print img_picto($langs->trans("Disabled"), 'switch_off');
}
print '</td></tr>';

print '</table>';

if (!empty($conf->global->FICHAJES_GEOLOCALIZACION) && isset($_COOKIE['geopos'])) {
    print '<div class="tabsAction">';
    print '<a href="' . $_SERVER['PHP_SELF'].'?action=testgeoposition" class="butAction">Test geolocalización</a>';
    if ($action == 'testgeoposition') {
        print "<a href=".generateMapsLink($_COOKIE['geopos'], true)." target='_blank'>Ya puedes consultar tu posición en Maps</a>";
    }
    print '</div>';
}

// Page end
dol_fiche_end();

llxFooter();
$db->close();
