<?php
/* Copyright (C) 2004-2017 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2019 SuperAdmin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file    fichajes/admin/setup.php
 * \ingroup fichajes
 * \brief   Fichajes setup page.
 */

// Load Dolibarr environment
$res = 0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (!$res && !empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) {
    $res = @include $_SERVER["CONTEXT_DOCUMENT_ROOT"] . "/main.inc.php";
}

// Try main.inc.php into web root detected using web root calculated from SCRIPT_FILENAME
$tmp = empty($_SERVER['SCRIPT_FILENAME']) ? '' : $_SERVER['SCRIPT_FILENAME'];
$tmp2 = realpath(__FILE__);
$i = strlen($tmp) - 1;
$j = strlen($tmp2) - 1;
while ($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i] == $tmp2[$j]) {
    $i--;
    $j--;
}
if (!$res && $i > 0 && file_exists(substr($tmp, 0, ($i + 1)) . "/main.inc.php")) {
    $res = @include substr($tmp, 0, ($i + 1)) . "/main.inc.php";
}

if (!$res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i + 1))) . "/main.inc.php")) {
    $res = @include dirname(substr($tmp, 0, ($i + 1))) . "/main.inc.php";
}

// Try main.inc.php using relative path
if (!$res && file_exists("../../main.inc.php")) {
    $res = @include "../../main.inc.php";
}

if (!$res && file_exists("../../../main.inc.php")) {
    $res = @include "../../../main.inc.php";
}

if (!$res) {
    die("Include of main fails");
}

global $langs, $user;

// Libraries
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
require_once '../lib/fichajes.lib.php';
require_once DOL_DOCUMENT_ROOT . '/custom/fichajes/class/enum/signing_trigger.class.php';
require_once DOL_DOCUMENT_ROOT . '/custom/fichajes/class/fichaje.class.php';

// Translations
$langs->load("admin");
$langs->load("fichajes@fichajes");

// Access control
if (!$user->admin) {
    accessforbidden();
}

// Parameters
$action = GETPOST('action', 'alpha');
$backtopage = GETPOST('backtopage', 'alpha');

$selectedMonth = GETPOST('month', 'int');
$selectedYear = GETPOST('year', 'int');
$selectedUser = GETPOST('selecteduser', 'int');
if (empty($selectedUser)) {
    $selectedUser = -1;
}

$timetable = array();

// Get data
$fichaje = new Fichaje($db);
$totalSignings = $fichaje->getNumberOfTotalSignings();

$limit = 20;
$page = GETPOST('page', 'int') ? GETPOST('page', 'int') : 1;
$totalPages = ceil($totalSignings / $limit);

$signings = null;

/*
 * Actions
 */
if ((float)DOL_VERSION >= 6) {
    include DOL_DOCUMENT_ROOT . '/core/actions_setmoduleoptions.inc.php';
}

if ($action == "export") {
    $signings = $fichaje->getAll();

    $filePath = DOL_DATA_ROOT . '/exported_data.csv';
    $fp = fopen($filePath, 'w');
    fprintf($fp, chr(0xEF) . chr(0xBB) . chr(0xBF));

    foreach ($signings as $signing) {
        $objVars = get_object_vars($signing);
        unset($objVars['tms']);
        fputcsv($fp, $objVars);
    }

    fclose($fp);

    sendFile($filePath);
    exit;
} else {
    $signings = $fichaje->getAll($limit * ($page - 1), $limit);
}

/*
 * View
 */

$page_name = "RegistroDeFichajes";
llxHeader('', $langs->trans($page_name));

// Subheader
$linkback = '<a href="' . ($backtopage ? $backtopage : DOL_URL_ROOT . '/admin/modules.php?restore_lastsearch_values=1') . '">' . $langs->trans("BackToModuleList") . '</a>';

print load_fiche_titre($langs->trans($page_name), $linkback, 'object_fichajes@fichajes');

// Configuration header
$head = fichajesAdminPrepareHead();
dol_fiche_head($head, 'signings', '', -1, "fichajes@fichajes");

print '<div class="fichecenter"><div class="fichethirdleft"><div>';

print '<div class="tabsAction">';
print '<div style="float:left; margin: 1.5rem 0 0" class="titre">Todos los registros</div>';
print '<div class="pagination">';
print '<a class="butAction" href="' . $_SERVER["PHP_SELF"] . '?action=export">' . $langs->trans("ExportarCSV") . '</a>';
if (($page - 1) > 0) {
    print '<a href="' . $_SERVER["PHP_SELF"] . '?page=' . ($page - 1) . '" class="page-indicator">Previa</a>';
}
print '<span class="page-indicator active">' . $page . "</span>";
if (($page + 1) <= $totalPages) {
    print '<a href="' . $_SERVER["PHP_SELF"] . '?page=' . ($page + 1) . '" class="page-indicator">Siguiente</a>';
}

print '</div>';
print '</div>';


print '<table class="noborder" style="margin-bottom: 2rem" width="100%">';
print '<tr class="liste_titre"><td class="titlefield">' . $langs->trans("Usuario") . '</td><td>' . $langs->trans("Fecha") . '</td><td>' . $langs->trans("Movimiento") . '</td><td>' . $langs->trans("Descripcion") . '</td><td>' . $langs->trans("Geoposicionamiento") . '</td>';

if (count($signings) > 0) {
    foreach ($signings as $signing) {
        $mov_trigger = "";
        if ($signing->mov_trigger == SigningTrigger::AUTO) {
            $mov_trigger = "(auto)";
        }

        print '<tr class="oddeven">';
        print '<td>' . trim($signing->username) . '</td>';
        print '<td>' . dol_print_date($signing->tms, '%d %B %Y %H:%M:%S') . '</td>';
        print '<td>' . $signing->mov_type . ' ' . $mov_trigger . '</td>';
        print '<td>' . $signing->description . '</td>';
        if (!empty($signing->geoposition)) {
            print '<td><a href="' . generateMapsLink($signing->geoposition) . '" target="_blank">' . $langs->trans("AbrirEnMaps") . '</a></td>';
        } else {
            print '<td></td>';
        }
        print '</tr>';
    }
} else {
    print '<td>' . $langs->trans("SinRegistros") . '</td>';
}

print '</table></div>';

print '</div><div class="fichetwothirdright"><div class="ficheaddleft">';
print '<div style="float:left;" class="titre">Registros por usuario</div>';
print '<div style="float:right; margin-bottom: .75rem">';
$form = new Form($db);
print $form->select_dolusers($selectedUser, 'user', 1, $exclude, 0, '', '', $object->entity, 0, 0, '', 0, '', 'maxwidth300');
print showMonthPicker($selectedMonth, $page);
$fichaje = new Fichaje($db);
$fichaje->userid = $user->id;
$firstYear = $fichaje->getFirstYear();
print showYearPicker($firstYear, $selectedYear);
print '</div>';
print '<div style="margin-top: 3rem">';
print '<table class="noborder small" width="100%">';
print '<tr><th style="text-align: left">Día</th><th style="text-align: left">Jornada</th><th style="text-align: left">Pausas</th></tr>';

if ($selectedUser > 0) {
    $fichajesPorUsuario = new Fichaje($db);
    $fichaje->userid = $selectedUser;
    $dailyRegister = $fichaje->getDailyRegister($selectedMonth, $selectedYear);

    $totalWorkingTime = 0;
    $totalPauseTime = 0;
    
    foreach($dailyRegister as $day) {
        print '<tr>';
        print '<td>'.$day["i"].'</td>';
        print '<td>'.formatMinutes($day["workedTime"]).'</td>';
        print '<td>'.formatMinutes($day["pauseTime"]).'</td>';
        print '</tr>';

        $totalWorkingTime += $day["workedTime"];
        $totalPauseTime += $day["pauseTime"];
    }

    print '<tr><th align="left">Total</th><th align="left">' . formatMinutes($totalWorkingTime) . '</th><th align="left">' . formatMinutes($totalPauseTime) . '</th></tr>';
} else {
    print '<tr class="oddeven"><td colspan="3" class="opacitymedium">Selecciona un usuario para ver sus fichajes.</td></tr>';
}
print "</table></div>";
print '</div></div></div>';

print "<script>
$(function() {
    var userId = $('select[name=\"user\"]').val();
    var month = $('#monthPicker').val();

    $('select[name=\"user\"]').change(function(e) {
        var userId = $(this).val();
        window.location.href = '" . $_SERVER['PHP_SELF'] . "?page=" . $selectedPage . "&month='+month+'&selecteduser='+userId;
    });

    $('#monthPicker').on('change',function() {
        window.location.href = '" . $_SERVER['PHP_SELF'] . "?page=" . $selectedPage . "&month='+this.value+'&selecteduser='+userId;
    });
});

</script>";

// Page end
dol_fiche_end();

llxFooter();
$db->close();
