<?php
/* Copyright (C) 2001-2005 Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2015 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2012 Regis Houssin        <regis.houssin@inodbox.com>
 * Copyright (C) 2015      Jean-François Ferry    <jfefe@aternatik.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *    \file       htdocs/fichajes/template/fichajesindex.php
 *    \ingroup    fichajes
 *    \brief      Home page of fichajes top menu
 */

// Load Dolibarr environment
$res = 0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (!$res && !empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) {
    $res = @include $_SERVER["CONTEXT_DOCUMENT_ROOT"] . "/main.inc.php";
}

// Try main.inc.php into web root detected using web root calculated from SCRIPT_FILENAME
$tmp = empty($_SERVER['SCRIPT_FILENAME']) ? '' : $_SERVER['SCRIPT_FILENAME'];
$tmp2 = realpath(__FILE__);
$i = strlen($tmp) - 1;
$j = strlen($tmp2) - 1;
while ($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i] == $tmp2[$j]) {$i--;
    $j--;}
if (!$res && $i > 0 && file_exists(substr($tmp, 0, ($i + 1)) . "/main.inc.php")) {
    $res = @include substr($tmp, 0, ($i + 1)) . "/main.inc.php";
}

if (!$res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i + 1))) . "/main.inc.php")) {
    $res = @include dirname(substr($tmp, 0, ($i + 1))) . "/main.inc.php";
}

// Try main.inc.php using relative path
if (!$res && file_exists("../main.inc.php")) {
    $res = @include "../main.inc.php";
}

if (!$res && file_exists("../../main.inc.php")) {
    $res = @include "../../main.inc.php";
}

if (!$res && file_exists("../../../main.inc.php")) {
    $res = @include "../../../main.inc.php";
}

if (!$res) {
    die("Include of main fails");
}

require_once DOL_DOCUMENT_ROOT . '/core/class/html.formfile.class.php';
require_once DOL_DOCUMENT_ROOT . '/custom/fichajes/class/fichaje.class.php';
require_once DOL_DOCUMENT_ROOT . '/custom/fichajes/lib/fichajes.lib.php';
require_once DOL_DOCUMENT_ROOT . '/custom/fichajes/class/enum/signing_trigger.class.php';

// Load translation files required by the page
$langs->load("fichajes@fichajes");

$action = GETPOST('action', 'alpha');

$now = dol_now();

// Securite acces client
if (!$user->rights->fichajes->read) {
    accessforbidden();
}

$socid = GETPOST('socid', 'int');
if (isset($user->societe_id) && $user->societe_id > 0) {
    $action = '';
    $socid = $user->societe_id;
}
$selectedMonth = GETPOST('month', 'int');
$selectedYear = GETPOST('year', 'int');
$previousSigning = GETPOST('prevsigning', 'alpha');

// Autosalida
if ($conf->global->FICHAJES_AUTO_FICHAJE_SALIDA) {
	$fichajeAutoSalida = new Fichaje($db);
	$fichajeAutoSalida->userid = $user->id;
	$fichajeAutoSalida->doScheduledExit();
}

$fichaje = new Fichaje($db);
$fichaje->geoposition = getGeoposition();
$fichaje->userid = $user->id;
$fichaje->trigger = SigningTrigger::MANUAL;
$fichaje->date = $now;
if (empty($previousSigning)) {
	$previousSigning = $fichaje->getPrevious();
}

$limit = 20;
$page = GETPOST('page', 'int') ? GETPOST('page', 'int') : 1;

global $conf;

/*
 * Actions
 */

if ($action == "ficharentrada") {
	$fichaje->type = "Entrada";
	$fichaje->insert();
	header('location: ' . $_SERVER["PHP_SELF"] . "?" . $_SERVER['QUERY_STRING']);
} elseif ($action == "ficharsalida") {
	$fichaje->type = "Salida";
	$fichaje->insert();
	header('location: ' . $_SERVER["PHP_SELF"] . "?" . $_SERVER['QUERY_STRING']);
} elseif ($action == "ficharpausa_confirmar") {
    $fichaje->type = "Pausa";
    $fichaje->description = GETPOST('description', 'alpha');
	$fichaje->insert();
	header('location: ' . $_SERVER["PHP_SELF"]);
} elseif ($action == "ficharreanudacion") {
	$fichaje->type = "Reanudacion";
	$fichaje->insert();
	header('location: ' . $_SERVER["PHP_SELF"] . "?" . $_SERVER['QUERY_STRING']);
} elseif ($action == 'commentmov_confirm') {
	$fichaje->id = GETPOST('movid', 'int');
	$fichaje->description = GETPOST('description', 'alpha');
	$fichaje->update();
	header('location: ' . $_SERVER["PHP_SELF"]);
}

/*
 * View
 */

$form = new Form($db);
$formfile = new FormFile($db);

llxHeader("", $langs->trans("Fichajes"));

print load_fiche_titre($langs->trans("Fichajes"), '', 'fichajes.png@fichajes');

if ($action == 'ficharpausa') {
	$entryExists = false;
	
    if ($conf->global->FICHAJES_PAUSA_REQUIERE_NUEVA_ENTRADA) {
		// Antes de una pausa tiene que haber necesariamente una entrada
        $sql = "SELECT fl.mov_type FROM " . MAIN_DB_PREFIX . "fichajes_log fl WHERE user_id = ".$user->id." ORDER BY fl.tms DESC LIMIT 1";
		$res = $db->query($sql);

        if ($res) {
            $num = $db->num_rows($res);
            if ($num > 0) {
                $obj = $db->fetch_object($res);
                if ($obj->mov_type == "Entrada") {
                    $entryExists = true;
                }
            }
        } 
	}
	
	if (!$entryExists && $conf->global->FICHAJES_PAUSA_REQUIERE_NUEVA_ENTRADA) {
		setEventMessages($langs->transnoentities("ErrorEntryRequired"), null, 'errors');
	} else {
		$formquestion = array(
			'description' => array('type' => 'text', 'label' => 'Descripción de la pausa', 'value' => '', 'name' => 'description'),
		);

		$formconfirm = $form->formconfirm($_SERVER["PHP_SELF"] . '?prevsigning=Pausa', 'Pausa', '', 'ficharpausa_confirmar', $formquestion, 0, 1);
		print $formconfirm;
	}
} elseif ($action == 'commentmov') {
	$formquestion = array(
		'description' => array('type' => 'text', 'label' => 'Descripción del fichaje', 'value' => '', 'name' => 'description'),
	);

	$movId = GETPOST('movid', 'int');

	$formconfirm = $form->formconfirm($_SERVER["PHP_SELF"] . '?movid=' . $movId, 'Fichaje', '', 'commentmov_confirm', $formquestion, 0, 1);
	print $formconfirm;
}

print '<div class="fichecenter"><div class="fichethirdleft"><div>';

if ($previousSigning == null || $previousSigning == "Salida" || ($previousSigning == "Pausa" && $conf->global->FICHAJES_PAUSA_REQUIERE_NUEVA_ENTRADA)) {
	print '<form name="ficharentrada" style="display: inline" action="' . $_SERVER["PHP_SELF"] . '" method="POST">' . "\n";
	print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
	print '<input type="hidden" name="action" value="ficharentrada">';
	print '<input type="hidden" name="prevsigning" value="Entrada">';
	
	print '<input class="butAction" style="text-decoration: none;
	text-transform: uppercase;
	font-weight: bold;
	margin: 0em 0.9em !important;
	padding: 0.6em 0.7em;
	font-family: roboto, arial, tahoma, verdana, helvetica;
	display: inline-block;
	text-align: center;
	cursor: pointer;
	color: rgb(51,102,0);
	background: rgb(217, 228,207);" type="submit" value="Entrada">';
	print '</form>';
}

if ($previousSigning == "Entrada" || $previousSigning == "Reanudacion") {
	print '<form name="ficharsalida" style="display: inline"  action="' . $_SERVER["PHP_SELF"] . '" method="POST">' . "\n";
	print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
	print '<input type="hidden" name="action" value="ficharsalida">';
	print '<input type="hidden" name="prevsigning" value="Salida">';
	
	print '<input class="butAction butActionRed" style="text-decoration: none;
	text-transform: uppercase;
	font-weight: bold;
	margin: 0em 0.9em !important;
	padding: 0.6em 0.7em;
	font-family: roboto, arial, tahoma, verdana, helvetica;
	display: inline-block;
	text-align: center;
	cursor: pointer;
	color: rgb(102,0,0);
	background: rgb(255, 204,204);" type="submit" value="Salida">';
	print '</form>';
}

if ($previousSigning == "Pausa" && !$conf->global->FICHAJES_PAUSA_REQUIERE_NUEVA_ENTRADA) {
	print '<form name="ficharreanudacion" style="display: inline"  action="' . $_SERVER["PHP_SELF"] . '" method="POST">' . "\n";
	print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
	print '<input type="hidden" name="action" value="ficharreanudacion">';
	print '<input type="hidden" name="prevsigning" value="Reanudacion">';
	
	print '<input class="butAction" style="text-decoration: none;
	text-transform: uppercase;
	font-weight: bold;
	margin: 0em 0.9em !important;
	padding: 0.6em 0.7em;
	font-family: roboto, arial, tahoma, verdana, helvetica;
	display: inline-block;
	text-align: center;
	cursor: pointer;
	color: rgb(0,51,102);
	background: rgb(204, 229,255);"" type="submit" value="Reanudación">';
	print '</form>';
}

if ($conf->global->FICHAJES_PERMITIR_PAUSAS && ($previousSigning == "Entrada" || ($previousSigning == "Reanudacion" && !$conf->global->FICHAJES_PAUSA_REQUIERE_NUEVA_ENTRADA))) {
	print '<form name="ficharpausa" style="display: inline"  action="' . $_SERVER["PHP_SELF"] . '" method="POST">' . "\n";
	print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
	print '<input type="hidden" name="action" value="ficharpausa">';
	
	print '<input class="butAction" style="text-decoration: none;
	text-transform: uppercase;
	font-weight: bold;
	margin: 0em 0.9em !important;
	padding: 0.6em 0.7em;
	font-family: roboto, arial, tahoma, verdana, helvetica;
	display: inline-block;
	text-align: center;
	cursor: pointer;
	color: rgb(0,51,102);
	background: rgb(204, 229,255);"" type="submit" value="Pausa">';
	print '</form>';
}

if (!empty($conf->fichajes->enabled) && $user->rights->fichajes->read) {
    $langs->load("orders");

    $sql = "SELECT COUNT(fl.rowid) as total";
    $sql .= " FROM " . MAIN_DB_PREFIX . "fichajes_log fl";
    $sql .= " WHERE fl.user_id = " . $user->id;

    $res = $db->query($sql);
    $obj = $db->fetch_object($res);
    $totalSignings = $obj->total;

    $sql = "SELECT fl.*";
    $sql .= " FROM " . MAIN_DB_PREFIX . "fichajes_log fl";
    $sql .= " WHERE fl.user_id = " . $user->id;
    $sql .= " ORDER BY fl.tms DESC";
    $sql .= " LIMIT " . $limit * ($page - 1) . "," . $limit;

    $resql = $db->query($sql);
    if ($resql) {
        $num = $db->num_rows($resql);

        $totalPages = ceil($totalSignings / $limit);

        print '</div><div class="pagination">';
        if (($page - 1) > 0) {
            print '<a href="' . $_SERVER["PHP_SELF"] . '?page=' . ($page - 1) . '" class="page-indicator">Previa</a>';
        }
        print '<span class="page-indicator active">' . $page . "</span>";
        if (($page + 1) <= $totalPages) {
            print '<a href="' . $_SERVER["PHP_SELF"] . '?page=' . ($page + 1) . '" class="page-indicator">Siguiente</a>';
        }

        print '</div>';
        print '<div><table class="noborder" width="100%">';
        print '<tr class="liste_titre">';
        print '<th colspan="4">Histórico de fichajes ' . ($num ? ' <span class="badge">' . $totalSignings . '</span>' : '') . '</th></tr>';

        if ($num > 0) {
            $i = 0;
            $lastDay = "";
            while ($i < $num) {
                $obj = $db->fetch_object($resql);
                $weekDay = dol_print_date($db->jdate($obj->tms), '%A %d'); //date("l j", strtotime($obj->tms));
                if ($weekDay != $lastDay) {
                    print '<tr>';
                    print '<td colspan="4"><strong>' . $weekDay . '</strong></td>';
					print '</tr>';
                    $lastDay = $weekDay;
                }

				print '<tr class="oddeven"><td class="nowrap">';
				print dol_print_date($db->jdate($obj->tms), '%H:%M:%S');
                print '</td>';
				print '<td class="nowrap">';
				$movType = $obj->mov_type;
				if ($obj->mov_type == "Reanudacion") {
					$movType = $langs->trans("Reanudacion");
				}
                print $movType;
                print '</td>';
				print '<td align="right" class="nowrap">' . $obj->description . '</td>';
				if ($obj->mov_type != 'Pausa' && $obj->mov_type != 'Reanudacion') {
					print '<td align="right"><a href="' . $_SERVER["PHP_SELF"] .'?action=commentmov&movid='.$obj->rowid.'"><span class="fa fa-pencil marginleftonly valignmiddle pictoedit" style="color: #444;" alt="Introducir comentario" title="Introducir comentario"></span></a></td>';
				} else {
					print '<td></td>';
				}
				
				print '</tr>';
                $i++;
            }
        } else {
            print '<tr class="oddeven"><td colspan="3" class="opacitymedium">No hay fichajes registrados.</td></tr>';
        }
        print "</table></div><br>";

        $db->free($resql);
    } else {
        dol_print_error($db);
    }
}

print '</div><div class="fichetwothirdright"><div class="ficheaddleft">';

print '<div style="float:right; margin-bottom: .75rem">';

print showMonthPicker($selectedMonth, $page);
$fichaje = new Fichaje($db);
$fichaje->userid = $user->id;
$firstYear = $fichaje->getFirstYear();
print showYearPicker($firstYear, $selectedYear);
print '</div>';

print '<div style="margin-top: 3rem"><table class="noborder small" width="100%">';
        print '<tr class="liste_titre">';
		print '<th colspan="3">Registro mensual</th></tr>';
		
		print '<tr><th style="text-align: left">Día</th><th style="text-align: left">Jornada</th><th style="text-align: left">Pausas</th></tr>';

		$fichaje = new Fichaje($db);
		$fichaje->userid = $user->id;
		$dailyRegister = $fichaje->getDailyRegister($selectedMonth, $selectedYear);

        if (!empty($dailyRegister)) {
            foreach($dailyRegister as $day) {
				print '<tr>';
				print '<td>'.$day["i"].'</td>';
				print '<td>'.formatMinutes($day["workedTime"]).'</td>';
				print '<td>'.formatMinutes($day["pauseTime"]).'</td>';
				print '</tr>';
			}
        } else {
            print '<tr class="oddeven"><td colspan="3" class="opacitymedium">No hay fichajes registrados.</td></tr>';
        }
        print "</table></div><br>";

print '</div></div></div>';

print "<script>
$(function() {
    $('#monthPicker').on('change',function() {
        window.location.href = '" . $_SERVER['PHP_SELF'] . "?page=" . $selectedPage . "&month='+this.value;
    });
});

</script>";

// End of page
llxFooter();
$db->close();
