<?php
/* Copyright (C) 2003-2004 Rodolphe Quiedeville         <rodolphe@quiedeville.org>
 * Copyright (C) 2004-2011 Laurent Destailleur          <eldy@users.sourceforge.net>
 * Copyright (C) 2014 Ferran Marcet  					<fmarcet@2byte.es>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *      \file       htdocs/admin/facture.php
 *		\ingroup    facture
 *		\brief      Page to setup invoice module
 */

$res=@include '../../main.inc.php';                                // For root directory
if (! $res) {$res=@include '../../../main.inc.php';}                // For "custom" directory

require_once DOL_DOCUMENT_ROOT. '/core/lib/admin.lib.php';
dol_include_once('/importator/lib/importator.lib.php');

global $langs, $user, $db, $conf;

$langs->load('admin');
$langs->load('importator@importator');
$langs->load('errors');

if (!$user->admin) {
    accessforbidden();
}
/*
 * Actions
 */

if (GETPOST('save'))
{
	$db->begin();

	$res=0;
	$res+=dolibarr_set_const($db,'IMPORT_TOTAL_STOCK',trim(GETPOST('impStock')),'chaine',0,'',$conf->entity);
	
	$res+=dolibarr_set_const($db,'IMPORT_BARCODE',trim(GETPOST('impBarcode')),'chaine',0,'',$conf->entity);
	
	$res+=dolibarr_set_const($db,'IMPORT_SEPARATOR',trim(GETPOST('IMPORT_SEPARATOR')),'chaine',0,'',$conf->entity);
	
	if ($res >= 3)
	{
		$db->commit();
		setEventMessage($langs->trans('ImpSetupSaved'));
	}
	else
	{
		$db->rollback();
		setEventMessage($langs->trans('Error'), 'errors');
		header('Location: ' .$_SERVER['PHP_SELF']);
		exit;
	}
}


/*
 * View
 */
llxHeader('',$langs->trans('ImportSetup'));
$html=new Form($db);

$head=importatoradmin_prepare_head();

dol_fiche_head($head, 'configuration', $langs->trans('Import'), 0, 'generic');

// read const
$impstock = dolibarr_get_const($db, 'IMPORT_TOTAL_STOCK',1);
$impbarcode = dolibarr_get_const($db, 'IMPORT_BARCODE',1);

//Page
$linkback='<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans('BackToModuleList').'</a>';
print load_fiche_titre($langs->trans('ImportSetup'),$linkback,'setup');
print '<br>';

print '<form name="catalogconfig" action="'.$_SERVER['PHP_SELF'].'" method="post">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';

/*
 *  General Optiones
 */
print load_fiche_titre($langs->trans('GeneralOptions'));
print '<table class="noborder" width="100%">';
print '<tr class="liste_titre">';
print '<td>'.$langs->trans('Parameter').'</td>';
print '<td align="center" width="60">'.$langs->trans('Value').'</td>';
print "</tr>\n";
$var=true;

// Total stock
$var=!$var;
print '<tr ' .$bc[$var?1:0]. '>';
print '<td>' .$langs->trans('ImpTotal'). '</td>';
print '<td>';
print $html->selectyesno('impStock',$impstock,1);
print '</td>';
print '</tr>';

// Fetch by barcode
$var=!$var;
print '<tr ' .$bc[$var?1:0]. '>';
print '<td>' .$langs->trans('ImpBarcode'). '</td>';
print '<td>';
print $html->selectyesno('impBarcode',$impbarcode,1);
print '</td>';
print '</tr>';

// csv separator
$var=!$var;
print '<tr '.$bc[$var?1:0].'>';
print '<td>'.$langs->trans('ImpCommaSeparator').'</td>';
print '<td align="left">';
print '<input type="text" class="flat" name="IMPORT_SEPARATOR" value="'. (GETPOST('IMPORT_SEPARATOR', 'alpha')?:$conf->global->IMPORT_SEPARATOR).'" size="5">';
print '</td>';
print '</tr>';

print '</table>';


print '<br><center>';
print '<input type="submit" name="save" class="button" value="'.$langs->trans('Save').'">';
print '</center>';
print "</form>\n";

//dol_fiche_end();

dol_htmloutput_events();


llxFooter();
$db->close();