<?php
/* Copyright (C) 2007 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2010-2014 	Jean Heimburger 	<jean@tiaris.info>
 * Copyright (C) 2014 		Ferran Marcet	 	<fmarcet@2byte.es>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/**
    	\file       dev/skeletons/skeleton_page.php
		\ingroup    mymodule othermodule1 othermodule2
		\brief      This file is an example of a php page
		\version    $Id: index.php,v 1.3 2010-05-11 22:21:37 jean Exp $
		\author		Put author name here
		\remarks	Put here some comments
*/

$res=@include '../main.inc.php';					// For root directory
if (! $res) {$res=@include '../../main.inc.php';}	// For "custom" directory
dol_include_once('/importator/class/importator.class.php');
global $langs, $langs, $user, $db;

$langs->load('companies');
$langs->load('other');
$langs->load('importator@importator');

// Protection if external user
if ($user->socid > 0 || empty($user->rights->importator->create))
{
	accessforbidden();
}

//dol_syslog("vars ".print_r($HTTP_POST_VARS,true), LOG_DEBUG);
$typeimport = GETPOST('type','alpha');
$importlibs = array('T'=>'ImportThirtdparty', 'C'=>'ImportContact', /*'A'=>'ImportActions',*/ 'P'=>'ImportProduct', 'TF'=>'Importtarif', 'S'=>'ImportStock');
$lib_import = $typeimport ?$importlibs["$typeimport"]: '';
$action = GETPOST('action','alpha');
dol_syslog(__FILE__. ':: type ' .$lib_import. '  ' . $typeimport. ' ' .$action, LOG_DEBUG);

/*******************************************************************
* ACTIONS
*
* Put here all code to do according to value of "action" parameter
********************************************************************/

// imports par fichiers
if ($action == 'ImportFile')
{

 // gestion des imports
	$nom_fic = $_FILES['fichier']['name'];
	$newfic = DOL_DATA_ROOT.'/'.$nom_fic; // dans le rep de travail
	$temp_fic = $_FILES['fichier']['tmp_name'];
    $res= 'ko';
	if ( move_uploaded_file($temp_fic, $newfic)) {$res = 'ok';}

	$import = new importator($db, $newfic,  $user);

	//recup des variables
	$firstline = GETPOST('firstline');
	$actionverif = GETPOST('verifier');
	$actionimport = GETPOST('importer');
	$typeaction = isset($_POST['Dolitype'])?GETPOST('Dolitype'):'';
		
	if ($firstline == 'on') {$import->firstline = 1;}
	$object = $importlibs["$typeimport"] ;
	if ($actionverif == 'on')
	{
		$imp_result = $import->validate_import($importlibs["$typeimport"]);
		
		if ($imp_result < 0 ) {
			setEventMessage($langs->trans('ErrValidation').':<br>'.$import->process_msg, 'errors');
		}
		else {
			setEventMessage($langs->trans('ValidationOK').$import->error);
		}
	}
	else {$imp_result = '';}
	if ($actionimport == 'on' && !$imp_result  )
	{
		$imp_result = $import->import2Dolibarr($importlibs["$typeimport"], $typeaction);
		if ($imp_result < 0) {
			setEventMessage($langs->trans('ErrImport').':<br>'.$import->process_msg, 'errors');
		}
		else {
			setEventMessage($langs->trans('ImportOK').$import->error);
		}
	}
}


/***************************************************
* PAGE
*
* Put here all code to build page
****************************************************/

llxHeader();

$form=new Form($db);

dol_htmloutput_events();

print load_fiche_titre($langs->trans('Imports') );
// Put here content of your page
// ...
print '<table class="notopnoleftnoright" width="75%" >';
print '<tr>';
print '<td width="20%">'.$langs->trans('ImportFileName').'</td>';
print '<td colspan="2"><form action="index.php" method="POST" enctype="multipart/form-data">';
print '<input type="file" name="fichier" size="40">';
print '<input type="hidden" name="action" value="ImportFile">';
print '</td></tr>';
print '<tr><td width="20%">&nbsp;</td><td>';
if (empty($typeimport) || (! $lib_import)) {
	print '<select name="type">';
	print '<option value="P">'.$langs->trans('ImportProduct').'</option>';
	print '<option value="TF">'.$langs->trans('Importtarif').'</option>';
	print '<option value="S">'.$langs->trans('ImportStock').'</option>';
	print '<option value="T">'.$langs->trans('ImportThirtdparty').'</option>';
	print '<option value="C">'.$langs->trans('ImportContact').'</option>';
	//print '<option value="A">'.$langs->trans("ImportActions").'</option>';
	print '</select>';
}
else {
	print '<br / >'.$langs->trans($lib_import). '<br />';
	print '<input type="hidden" name="type" value="'.$typeimport.'">';
	
}
print '</td></tr>';	
print '<tr><td width="20%">&nbsp;</td><td><input type="checkbox" name="firstline" checked></td><td>'.$langs->trans('ImportFirstLine').'</td></tr>';
print '<tr><td width="20%">&nbsp;</td><td><input type="checkbox" name="verifier"></td><td>'.$langs->trans('ImportVerif').'</td></tr>';
print '<tr><td width="20%">&nbsp;</td><td><input type="checkbox" name="importer"></td><td>'.$langs->trans('ImportFile').'</td>';
print '<td width="40%"><input type="Radio" name ="Dolitype" value="C" >'.$langs->trans('ImportCreate').'<br/>';
if($typeimport != 'S'){
	//print '<input type="Radio" name ="Dolitype" value="M" >'.$langs->trans("ImportUpdate").'<br/>';
	print '<input type="Radio" name ="Dolitype" value="D" >'.$langs->trans('ImportDel').'<br/><br/>';
}
print '</td></tr>';
if($typeimport == 'S'){
    $questionstock = 'PartialStock';
    if(!empty($conf->global->IMPORT_TOTAL_STOCK)) {
        $questionstock = 'TotalStock';
    }

	print '<tr><td width="20%"></td><td>'.img_picto($langs->trans('Warning'), 'warning'). ' ' .$langs->trans($questionstock).'</td></tr>';

    $questionbarcode = 'BarcodeNo';
	if(!empty($conf->global->IMPORT_BARCODE)){
		$questionbarcode = 'BarcodeYes';
	}

	print '<tr><td width="20%"></td><td>'.img_picto($langs->trans('Warning'), 'warning'). ' ' .$langs->trans($questionbarcode).'</td></tr>';
}
print'<tr><td colspan="3" align="center"><input type="submit" value="'.$langs->trans('Import').'">';
print '</td></form></tr>';
print '</table>';

print '<br/>';
if ($import->process_msg) {print '<p>'.nl2br($import->process_msg).'</p>';}



// End of page
llxFooter();
$db->close();


