<?php
/* Copyright (C) 2015-2021		Charlene Benke	<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\file	   htdocs/management/class/actions_management.class.php
 * 	\ingroup	extrodt
 * 	\brief	  Fichier de la classe des actions/hooks de management (pour les agendas partag�s)
 */

class ActionsMyschedule // extends CommonObject 
{
	/** Overloading the doActions function : replacing the parent's function with the one below 
	 *  @param	  parameters  meta datas of the hook (context, etc...) 
	 *  @param	  object			 the object you want to process 
	 *  @param	  action			 current action (if set). Generally create or edit or null 
	 *  @return	   void 
	 */
	 
	function formBuilddocOptions($parameters, $object, $action) 
	{
		global $conf, $langs, $db;
		global $user, $form;
		// si sur l'utilisateur et qu'il y a l'�dition d'active
//		print_r($conf);
		if ($object->element  == 'user' && $conf->global->USER_ADDON_PDF_ODT_PATH) {
			// on ajoute un liste pour le mode d'�dition
			$listselect="<tr><th align=left>";
			$listselect.=$langs->trans("PeriodFilter");

			switch($conf->global->MYSCHEDULE_PeriodFilter) {
				case "week" :
					//on récupère le premier et dernier jours de la semaine
					$timeStampPremierJanvier = strtotime(date('Y') . '-01-01');
					$jourPremierJanvier = date('w', $timeStampPremierJanvier);

					//-- recherche du Numéro de semaine du 1er janvier -------------------
					$numSemainePremierJanvier = date('W', $timeStampPremierJanvier);

					$decallage = date('W');
					if ($numSemainePremierJanvier == 1) 
						$decallage--;

					$timeStampDate = strtotime('+' . $decallage . ' weeks', $timeStampPremierJanvier);
					//-- recherche du lundi de la semaine en fonction de la ligne précédente ---------
					$datedeb = ($jourPremierJanvier == 1) ?  $timeStampDate : strtotime('last monday', $timeStampDate);
					$datefin = strtotime('+6 days', $datedeb);

					break;
				case "month" :
					$datedeb = dol_mktime(0, 0, 0, date('m'), 1, date('Y'));
					// on se positionne sur le dernier jours du mois
					$datefin = strtotime('-1 days', strtotime('+1 month', $datedeb));

					break;
				case "year" :
					$datedeb = dol_mktime(0, 0, 0, 1, 1, date('Y'));
					$datefin = dol_mktime(0, 0, 0, 12, 31, date('Y'));
					break;

			}
			

			if (GETPOST('datedebmonth', 'int'))
				$datedeb = dol_mktime(
								0, 0, 0,
								GETPOST('datedebmonth', 'int'),
								GETPOST('datedebday', 'int'),
								GETPOST('datedebyear', 'int')
				);

			if (GETPOST('datefinmonth', 'int'))
				$datefin = dol_mktime(
								0, 0, 0,
								GETPOST('datefinmonth', 'int'),
								GETPOST('datefinday', 'int'),
								GETPOST('datefinyear', 'int')
				);	

	
			$listselect.='</th><th colspan=3>' . $langs->trans("From") . '&nbsp;';
			$listselect.=$form->select_date($datedeb, 'datedeb', 0, 0, '', "datedeb", 1, 0, 1);
			$listselect.='&nbsp;' . $langs->trans("to") . '&nbsp;';
			$listselect.=$form->select_date($datefin, 'datefin', 0, 0, '', "datefin", 1, 0, 1);
			$listselect.="</th></tr>";

			$this->resprints = $listselect;

		}
		return 1;
	}
}