<?php
/* Copyright (C) 2014-2020		Charlene BENKE	<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	  \file	   myschedule.class.php
 *	  \ingroup	mySchedule
 *	  \brief	class principale du module
 */

require_once DOL_DOCUMENT_ROOT."/core/class/commonobject.class.php";

/**
 *	  \brief	  Class to manage tasks
 *	\remarks	Initialy built by build_class_from_table on 2008-09-10 12:41
 */
class fichinterdet_schedule extends CommonObject
{
	public $element='fichinterdet_schedule';
	var $rowid;
	var $fk_fichinterdet;
	var $fk_user;
	var $fk_product;
	var $duration_planned;
	var $duration_made;

	/**
	 *  Constructor
	 *
	 *  @param	  DoliDB		$db	  Database handler
	 */
	function __construct($db)
	{
		$this->db = $db;
	}


	function delete($id=0, $fk_user=0, $fk_fichinterdet=0)
	{
		$sql  = "DELETE FROM ".MAIN_DB_PREFIX."fichinterdet_schedule";
		if ($id > 0 )
			$sql.= " WHERE rowid =".$id;
		elseif ($fk_user > 0 && $fk_fichinterdet > 0) {
			$sql.= " WHERE fk_user =".$fk_user;
			$sql.= " AND fk_fichinterdet =".$fk_fichinterdet;
		} elseif ($fk_user == 0 && $fk_fichinterdet > 0) {
				$sql.= " WHERE fk_fichinterdet =".$fk_fichinterdet;
				
		} else {
			$this->error="Bad call id=".$id." fk_user=".$fk_user." fk_fichinterdet".$fk_fichinterdet;
			dol_syslog(get_class($this)."::DELETE ".$this->error, LOG_ERR);
			return -2;
		}
		//print $sql;
		if (!$this->db->query($sql)) {
			$this->error="Error ".$this->db->lasterror();
			dol_syslog(get_class($this)."::DELETE ".$this->error, LOG_ERR);
			return -1;
		}
		return 0;
	}

	function update($planned, $made)
	{
		global $user;
		$sql = "UPDATE ". MAIN_DB_PREFIX . "fichinterdet_schedule";
		$sql.= " set duration_planned = ".$planned;
		$sql.= " , duration_made = ".$made;

		$sql.= " WHERE rowid=".$this->rowid;

		$resql = $this->db->query($sql);
		if (! $resql) {
			$this->error="Error ".$this->db->lasterror();
			dol_syslog(get_class($this)."::UPDATE ".$this->error, LOG_ERR);
			return -1;
		}

		return 1;

	}
	
	function insert()
	{
		$sql = "INSERT ". MAIN_DB_PREFIX . "fichinterdet_schedule (fk_user,";
		$sql.= " fk_fichinterdet, fk_product, duration_planned, duration_made";
		$sql.= " ) VALUES ( " ;
		$sql.= " ".$this->fk_user;
		$sql.= ", ".$this->fk_fichinterdet;
		$sql.= ", ".($this->fk_product?$this->fk_product:"null");
		$sql.= ", ".($this->duration_planned?$this->duration_planned:"0");
		$sql.= ", ".($this->duration_made?$this->duration_made:"0");
		$sql.=")";
		//print $sql."<br>";
		$resql = $this->db->query($sql);
		if (! $resql) {
			$this->error="Error ".$this->db->lasterror();
			dol_syslog(get_class($this)."::INSERT ".$this->error, LOG_ERR);
			return -1;
		}

		return 1;
	}

	function fetch($id=0, $fk_user=0, $fk_fichinterdet = 0)
	{
		// on récupère les schedule 
		$sql = "SELECT * FROM ".MAIN_DB_PREFIX."fichinterdet_schedule" ;
		if ($id > 0)
			$sql.= " WHERE rowid =".$id;
		elseif($fk_user == 0 && $fk_fichinterdet > 0)
			$sql.= " WHERE fk_fichinterdet =".$fk_fichinterdet;
		elseif($fk_user > 0 && $fk_fichinterdet > 0) {
			$sql.= " WHERE fk_user =".$fk_user;
			$sql.= " AND fk_fichinterdet =".$fk_fichinterdet;
		} else {
			print 'erreur sur le param�trage du fetch';
			return -2;
		}

		dol_syslog(get_class($this)."::fetch_lines sql=".$sql, LOG_DEBUG);
		$resql=$this->db->query($sql);
		if ($resql) {
			$result = $this->db->fetch_array($resql);

			if ($result) {
				$this->rowid				= $result["rowid"];
				$this->fk_user				= $result["fk_user"];
				$this->fk_fichinterdet		= $result["fk_fichinterdet"];
				$this->fk_product			= $result["fk_product"];
				$this->duration_planned		= $result["duration_planned"];
				$this->duration_made		= $result["duration_made"];
				return $this->rowid;
			} else	// Si on a rien trouv�
				return 0;

			$this->db->free($resql);
		} else {
			$this->error="Error ".$this->db->lasterror();
			dol_syslog(get_class($this)."::fetch".$this->error, LOG_ERR);

			return -1;
		}
		return $this->rowid;
	}

	// on renvoie la liste des shedule associé à une ligne d'inter, une inter et/ou un user
	function fetch_all($fk_fichinterdet=0, $fk_user=0, $fk_fichinter=0)
	{
		// on récupère les schedule 
		$sql = "SELECT * FROM ".MAIN_DB_PREFIX."fichinterdet_schedule as fs" ;
		if ($fk_fichinter >0) {
			$sql.= " ,".MAIN_DB_PREFIX."fichinterdet as fid";
			$sql.= " WHERE fs.fk_fichinterdet = fid.rowid";
			$sql.= " AND fid.rowid = ".$fk_fichinter;
		} else
			$sql.= " WHERE fs.fk_fichinterdet =".$fk_fichinterdet;

		if ($fk_user> 0)
			$sql.= " AND fs.fk_user =".$fk_user;

		dol_syslog(get_class($this)."::fetch_lines sql=".$sql, LOG_DEBUG);
		$resql=$this->db->query($sql);
		if ($resql) {
			$elems = array ();
			while ($rec = $this->db->fetch_array($resql)) {
				$elem = array ();
				$elem["rowid"]				= $rec["rowid"];
				$elem["fk_user"]			= $rec["fk_user"];
				$elem["fk_product"]			= $rec["fk_product"];
				$elem["duration_planned"]	= $rec["duration_planned"];
				$elem["duration_made"]		= $rec["duration_made"];
				$elems[$rec['rowid']] = $elem;
			} 
			return $elems;
			
		} else {
			$this->error="Error ".$this->db->lasterror();
			dol_syslog(get_class($this)."::fetch".$this->error, LOG_ERR);

			return -1;
		}
	}
}
