<?php
/* Copyright (C) 2014-2021	Charlene BENKE	<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
include_once(DOL_DOCUMENT_ROOT ."/core/modules/DolibarrModules.class.php");

/**
 * 		\class	  modcustomline
 *	  \brief	  Description and activation class for module myschedule
 */
class modmyschedule extends DolibarrModules
{

	var $disabled = false;
	
	/**
	 *   \brief	  Constructor. Define names, constants, directories, boxes, permissions
	 *   \param	  DB	  Database handler
	 */
	function __construct($db)
	{
		
		$this->db = $db;

		global $conf, $langs;

		$langs->load('myschedule@myschedule');

		// Id for module (must be unique).
		// Use here a free id (See in Home -> System information -> Dolibarr for list of used modules id).
		$this->numero = 160030;

		$this->editor_name = "<b>Patas-Monkey</b>";
		$this->editor_web = "http://www.patas-monkey.com";

		// Family can be 'crm','financial','hr','projects','products','ecm','technic','other'
		// It is used to group modules in module setup page
		$this->family = "hr";
		
		// Module label (no space allowed), used if translation string 'ModuleXXXName' not found (where XXX is value of numeric property 'numero' of module)
		$this->name = preg_replace('/^mod/i', '', get_class($this));
		// Module description, used if translation string 'ModuleXXXDesc' not found (where XXX is value of numeric property 'numero' of module)
		$this->description = $langs->trans("myschedulePresentation");

		// Possible values for version are: 'development', 'experimental', 'dolibarr' or version
		$this->version = $this->getLocalVersion();

		// Key used in llx_const table to save module status enabled/disabled (where MYMODULE is value of property name of module in uppercase)
		$this->const_name = 'MAIN_MODULE_'.strtoupper($this->name);
		// Where to store the module in setup page (0=common,1=interface,2=others,3=very specific)
		$this->special = 0;
		// Name of image file used for this module.
		// If file is in theme/yourtheme/img directory under name object_pictovalue.png, use this->picto='pictovalue'
		// If file is in module/img directory under name object_pictovalue.png, use this->picto='pictovalue@module'
		$this->picto=$this->name .'.png@'.$this->name ;

		// Defined if the directory /mymodule/inc/triggers/ contains triggers or not
		$this->module_parts = array(
		'models' => 1,
		'hooks' => array('formfile')
		);					

		// Data directories to create when module is enabled.
		// Example: this->dirs = array("/mymodule/temp");
		$this->dirs = array();
		$r=0;


		// Dependencies
		// List of modules id that must be enabled if this module is enabled
		$this->requiredby = array();	// List of modules id to disable if this one is disabled
		$this->phpmin = array(4,3);					// Minimum version of PHP required by module
		$this->need_dolibarr_version = array(3,4);	// Minimum version of Dolibarr required by module

		$this->langfiles = array($this->name ."@". $this->name );

		// Config pages
		$this->config_page_url = array("setup.php@".$this->name );

		// List of particular constants to add when module is enabled (key, 'chaine', value, desc, visible, 0 or 'allentities')
		$this->const = array(
			0 => array(
				'MYSCHEDULE_openonothertab', 'chaine', '0',
				$langs->trans("OpenOnOtherTabs"), 1, 'allentities', 1
			),
			1 => array(
				'MYSCHEDULE_showsubordinateuser', 'chaine', '0',
				$langs->trans("ShowSubordinateUser"), 1, 'allentities', 1
			),
			2 => array(
				'MYSCHEDULE_PeriodFilter', 'chaine', '0',
				$langs->trans("PeriodFilter"), 1, 'allentities', 1
			),
			3 => array(
				'MYSCHEDULE_nbnewlineinter', 'chaine', '1',
				$langs->trans("PeriodFilter"), 1, 'allentities', 1
			),
			4 => array(
				'MYSCHEDULE_nbcontactonlist', 'chaine', '1',
				$langs->trans("nbcontactonlist"), 1, 'allentities', 1
			),
			5 => array(
				'MYSCHEDULE_colornouser', 'chaine', 'F08080',
				$langs->trans("PeriodFilter"), 1, 'allentities', 1
			),
			6 => array(
				'MYSCHEDULE_colornotplanned', 'chaine', 'F4A460',
				$langs->trans("PeriodFilter"), 1, 'allentities', 1
			),
			7 => array(
				'MYSCHEDULE_colornotmade', 'chaine', '90EE90',
				$langs->trans("PeriodFilter"), 1, 'allentities', 1
			),
			8 => array(
				'MYSCHEDULE_colormade', 'chaine', 'E5E5E5',
				$langs->trans("PeriodFilter"), 1, 'allentities', 1
			),
			9 => array(
				'MYSCHEDULE_FormatDisplayMode', 'chaine', '0',
				$langs->trans("PeriodFilter"), 1, 'allentities', 1
			),
			10 => array(
				'MYSCHEDULE_startHourDay', 'chaine', '0',
				$langs->trans("PeriodFilter"), 1, 'allentities', 1
			),
			11 => array(
				'MYSCHEDULE_endHourDay', 'chaine', '23',
				$langs->trans("PeriodFilter"), 1, 'allentities', 1
			),
			12 => array(
				'MYSCHEDULE_startHourWork', 'chaine', '9',
				$langs->trans("PeriodFilter"), 1, 'allentities', 1
			),
			13 => array(
				'MYSCHEDULE_endHourWork', 'chaine', '20',
				$langs->trans("PeriodFilter"), 1, 'allentities', 1
			)

			

		);
		
		// Permissions
		$this->rights = array();
		$this->rights_class = $this->name;

		$r=0;
		$this->rights[$r][0] = 1600301; // id de la permission
		$this->rights[$r][1] = "Lire les temps plannifié"; // libelle de la permission
		$this->rights[$r][2] = 'R'; // type de la permission (deprecie a ce jour)
		$this->rights[$r][3] = 1; // La permission est-elle une permission par defaut
		$this->rights[$r][4] = 'lire';
		
		$r++;
		$this->rights[$r][0] = 1600302; // id de la permission
		$this->rights[$r][1] = "Saisir les temps plannifiés"; // libelle de la permission
		$this->rights[$r][2] = 'M'; // type de la permission (deprecie a ce jour)
		$this->rights[$r][3] = 1; // La permission est-elle une permission par defaut
		$this->rights[$r][4] = 'modif';

		$r++;
		$this->rights[$r][0] = 1600303; // id de la permission
		$this->rights[$r][1] = "accès à tous les utilisateur"; // libelle de la permission
		$this->rights[$r][2] = 'A'; // type de la permission (deprecie a ce jour)
		$this->rights[$r][3] = 0; // La permission est-elle une permission par defaut
		$this->rights[$r][4] = 'alluser';

		// ajouter d'autres droits pour l'accès aux temps planifiées en modif



		$r++;
		$this->menu[$r]=array(	'fk_menu'=>'fk_mainmenu=commercial,fk_leftmenu=ficheinter',
					'type'=>'left',
					'titre'=>'mySchedule',
					'mainmenu'=>'',
					'leftmenu'=>'',
					'url'=>'/myschedule/fichinter/fullcalendar.php',
					'langs'=>'myschedule@myschedule',
					'position'=>100,
					'enabled'=>'1',
					'perms'=>'1',
					'target'=>'',
					'user'=>2);


		// Array to add new pages in new tabs
		$tabsArray = array(
			 'intervention:+myschedule:mySchedule:myschedule@myschedule:/myschedule/fichinter/useraffect.php?id=__ID__'
			, 'thirdparty:+myschedule:mySchedule:myschedule@myschedule:/myschedule/tabs/societe.php?id=__ID__'
			, 'user:+myschedule:mySchedule:myschedule@myschedule:/myschedule/tabs/user.php?id=__ID__'
			, 'contact:+myschedule:mySchedule:myschedule@myschedule:/myschedule/tabs/contact.php?id=__ID__'

		);
		$this->tabs = $tabsArray;

		// Boxes
		$this->boxes = array();			// List of boxes
		$r=0;

		// penser à faire un export, voir deux

	}

	/**
	 *		\brief	  Function called when module is enabled.
	 *					The init function add constants, boxes, permissions and menus (defined in constructor) into Dolibarr database.
	 *					It also creates data directories.
	 *	  \return	 int			 1 if OK, 0 if KO
	 */
	function init($options="")
	{
		$sql = array();

		$result=$this->load_tables();

		return $this->_init($sql);
	}

	/**
	 *		\brief		Function called when module is disabled.
	 *			  	Remove from database constants, boxes and permissions from Dolibarr database.
	 *					Data directories are not deleted.
	 *	  \return	 int			 1 if OK, 0 if KO
	 */
	function remove($options='')
	{
		$sql = array();
		return $this->_remove($sql, $options);
	}

	/**
	 *		Create tables, keys and data required by module
	 * 		Files llx_table1.sql, llx_table1.key.sql llx_data.sql with create table, create keys
	 * 		and create data commands must be stored in directory /mymodule/sql/
	 *		This function is called by this->init.
	 *
	 * 		@return		int		<=0 if KO, >0 if OK
	 */
	function load_tables()
	{
		return $this->_load_tables('/myschedule/sql/');
	}

	function getChangeLog()
	{
		// Libraries
		dol_include_once("/".$this->name."/core/lib/patasmonkey.lib.php");
		return getChangeLog($this->name);
	}

	function getVersion($translated = 1)
	{
		global $langs, $conf;
		$currentversion = $this->version;

		if (!empty($conf->global->PATASMONKEY_SKIP_CHECKVERSION) && $conf->global->PATASMONKEY_SKIP_CHECKVERSION == 1)
			return $currentversion;

		if ($this->disabled) {
			$newversion= $langs->trans("DolibarrMinVersionRequiered")." : ".$this->dolibarrminversion;
			$currentversion="<font color=red><b>".img_error($newversion).$currentversion."</b></font>";
			return $currentversion;
		}

		$context  = stream_context_create(array('http' => array('header' => 'Accept: application/xml')));
		$changelog = @file_get_contents(str_replace("www","dlbdemo", $this->editor_web).'/htdocs/custom/'.$this->name.'/changelog.xml',false, $context);
		//$changelog = @file_get_contents($this->editor_web.$this->editor_version_folder.$this->name.'/');

		if ($changelog === false)	// not connected
			return $currentversion;
		else {
			$sxelast = simplexml_load_string(nl2br ($changelog));
			if ($sxelast === false) 
				return $currentversion;
			else
				$tblversionslast=$sxelast->Version;

			$lastversion = $tblversionslast[count($tblversionslast)-1]->attributes()->Number;

			if ($lastversion != (string) $this->version) {
				$newversion= $langs->trans("NewVersionAviable")." : ".$lastversion;
				$currentversion="<font title='".$newversion."' color=orange><b>".$currentversion."</b></font>";
			}
		}
		return $currentversion;
	}

	function getLocalVersion()
	{
		global $langs;
		$context  = stream_context_create(array('http' => array('header' => 'Accept: application/xml')));
		$changelog = @file_get_contents(dol_buildpath($this->name,0).'/changelog.xml',false, $context);
		$sxelast = simplexml_load_string(nl2br ($changelog));
		if ($sxelast === false) 
			return $langs->trans("ChangelogXMLError");
		else {
			$tblversionslast=$sxelast->Version;
			$currentversion = $tblversionslast[count($tblversionslast)-1]->attributes()->Number;
			$tblDolibarr=$sxelast->Dolibarr;
			$MinversionDolibarr=$tblDolibarr->attributes()->minVersion;
			if ((int) DOL_VERSION < (int) $MinversionDolibarr) {
				$this->dolibarrminversion=$MinversionDolibarr;
				$this->disabled = true;
			}
		}
		return $currentversion;
	}
}
?>