<?php
/* Copyright (C) 2012 		Regis Houssin		<regis.houssin@capnetworks.com>
 * Copyright (C) 2016 		Laurent Destailleur	<eldy@users.sourceforge.net>
 * Copyright (C) 2018-2020	Charlene Benke		<charlie@patas-monkey.com>

 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *       \file       myschdule/ficheinter/ajax/event-changestatut.php
 *       \brief      File to load update an event
 */

if (! defined('NOTOKENRENEWAL')) define('NOTOKENRENEWAL','1'); // Disables token renewal
if (! defined('NOREQUIREMENU'))  define('NOREQUIREMENU','1');
//if (! defined('NOREQUIREHTML'))  define('NOREQUIREHTML','1');
if (! defined('NOREQUIREAJAX'))  define('NOREQUIREAJAX','1');
//if (! defined('NOREQUIRESOC'))   define('NOREQUIRESOC','1');
//if (! defined('NOREQUIRETRAN'))  define('NOREQUIRETRAN','1');

$res=0;
if (! $res && file_exists("../../../main.inc.php")) 
	$res=@include("../../../main.inc.php");		// For root directory
if (! $res && file_exists("../../../../main.inc.php")) 
	$res=@include("../../../../main.inc.php");	// For "custom" directory

dol_include_once('/fichinter/class/fichinter.class.php');

//$id = GETPOST('id', 'int');
$fk_fichinter = GETPOST('fk_fichinter', 'int');
$statut = GETPOST('statut', 'int');

/*
 * View
 */
top_httphead();

//print '<!-- Ajax page called with url '.dol_escape_htmltag($_SERVER["PHP_SELF"]).'?'.dol_escape_htmltag($_SERVER["QUERY_STRING"]).' -->'."\n";

if (! empty($fk_fichinter)) {
	$fichinter_static= new FichInter($db);
	$fichinter_static->fetch($fk_fichinter);
	switch($statut) {
		case 0 :
			$fichinter_static->setDraft($user);
			break;
		case 1 :
			// si déjà facturé ou clot on n'y retourne pas
			$fichinter_static->setValid($user);
			break;
		default :
			$sql = "UPDATE ".MAIN_DB_PREFIX."fichinter";
			$sql .= " SET fk_statut = ".$statut;
			$sql .= " WHERE rowid = ".$fk_fichinter;
			$resql = $db->query($sql);
			break;
	}
	echo json_encode($return);
}