<?php
/* Copyright (C) 2012 		Regis Houssin		<regis.houssin@capnetworks.com>
 * Copyright (C) 2016 		Laurent Destailleur	<eldy@users.sourceforge.net>
 * Copyright (C) 2018-2020	Charlene Benke		<charlie@patas-monkey.com>

 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *       \file       myschdule/ficheinter/ajax/event-clone.php
 *       \brief      File to clone an event
 */

if (! defined('NOTOKENRENEWAL')) define('NOTOKENRENEWAL','1'); // Disables token renewal
if (! defined('NOREQUIREMENU'))  define('NOREQUIREMENU','1');
//if (! defined('NOREQUIREHTML'))  define('NOREQUIREHTML','1');
if (! defined('NOREQUIREAJAX'))  define('NOREQUIREAJAX','1');
//if (! defined('NOREQUIRESOC'))   define('NOREQUIRESOC','1');
//if (! defined('NOREQUIRETRAN'))  define('NOREQUIRETRAN','1');

$res=0;
if (! $res && file_exists("../../../main.inc.php")) 
	$res=@include("../../../main.inc.php");		// For root directory
if (! $res && file_exists("../../../../main.inc.php")) 
	$res=@include("../../../../main.inc.php");	// For "custom" directory

dol_include_once('/core/lib/date.lib.php');
dol_include_once('/fichinter/class/fichinter.class.php');

$id = GETPOST('id', 'int');
$fk_fichinter = GETPOST('fk_fichinter', 'int');
$choiceperiod = GETPOST('choiceperiod', 'text');
// selon le mode de décallage
if ($choiceperiod =="week") {
	$selectyear = GETPOST('selectyear', 'text');
	$selectweek = GETPOST('selectweek', 'text');
} else {
	$selectyear = GETPOST('selectyearmonth', 'text');
	$selectmonth = GETPOST('selectmonth', 'text');
}
$withuser = GETPOST('withuser', 'text');


/*
 * View
 */
top_httphead();

//print '<!-- Ajax page called with url '.dol_escape_htmltag($_SERVER["PHP_SELF"]).'?'.dol_escape_htmltag($_SERVER["QUERY_STRING"]).' -->'."\n";

// Load original field value
if (! empty($id) && ! empty($fk_fichinter)) {

	// selon le mode de décallage
	if ($choiceperiod == 'week') {
		// on décale sur le semaine
		// on récupère le jour de la date d'intervention (de 0 à 6)
		$jourDateIntervention = date('w', $dateIntervention);
		//print "Jrsdti=".$jourDateIntervention."<br>" ;

		//ensuite on récupère le premier janvier
		$timeStampPremierJanvier = strtotime($selectyear . '-01-01');
		$jourPremierJanvier = date('w', $timeStampPremierJanvier);

		//on se positionne sur la semaine demandé -1 car on part de la première semaine
		$timeStampDate = strtotime('+' . ($selectweek-1) . ' weeks', $timeStampPremierJanvier);
		//-- recherche du lundi de la semaine en fonction de la ligne précédente ---------
		$firstdayweek = ($jourPremierJanvier == 1) ?  $timeStampDate : strtotime('last monday', $timeStampDate);
		//print "firstdayweek=".date("d-m-Y", $firstdayweek)."<br>";

		// on ne décale pas si c'est un lundi, sinon on ajoute X jours -1
		if ($jourDateIntervention == 1)
			$newdayweek = $firstdayweek;
		else
			$newdayweek = strtotime(date("Y-m-d", strtotime(date('d-m-Y', $firstdayweek)))." +".($jourDateIntervention-1)." day"); 

		$newDateInter=dol_mktime(
			date("H", $dateIntervention),
			date("i", $dateIntervention), '00',
			date("m", $newdayweek),
			date("d", $newdayweek),
			date("Y", $newdayweek)
		);
		//print "newdateinter=".date("d-m-Y", $newDateInter)."<br>";
	} else {
		// on décale sur le mois demandé
		$newDateInter=dol_mktime(
			$dateIntervention->format("H"),
			$dateIntervention->format("i"), '00',
			$periodmonth,
			$dateIntervention->format("d"),
			$periodyearmonth
		);
	}



	//on commence par vérifier que l'inter n'a pas pas déjà un clone sur cette date
	$sql = " SELECT ft.date as date_intervention";
	$sql.= " FROM ".MAIN_DB_PREFIX."fichinterdet as ft";
	$sql.= " WHERE ft.rowid =".$id;
	//$sql.= " AND f.import_key =".$id;
	// pour conserver l'origine du clonage
	$sql.= " AND ft.fk_parent_line =".$id;
	$sql.= " AND date_intervention='".$db->idate($newDateInter)."'";

	$resql = $db->query($sql);
	if ($resql) {
		// si il y a déjà un clone à cette date, pas la peine de la refaire
		if ($db->num_rows($resql)==0) {

		}
	}

	// récupération de la ligne d'intervention
	$sql= " SELECT ft.date as date_intervention FROM ".MAIN_DB_PREFIX."fichinterdet as ft";
	$sql.= " WHERE ft.rowid =".$id;
	$resql = $db->query($sql);
	if ($resql) {
		$objp = $db->fetch_object($resql);
		$dateIntervention = $db->jdate($objp->date_intervention);
		//print "dti=".date("d-m-y",$dateIntervention)."<br>";
		// selon le mode de décallage
		if ($choiceperiod == 'week') {
			// on décale sur le semaine
			// on récupère le jour de la date d'intervention (de 0 à 6)
			$jourDateIntervention = date('w', $dateIntervention);
			//print "Jrsdti=".$jourDateIntervention."<br>" ;

			//ensuite on récupère le premier janvier
			$timeStampPremierJanvier = strtotime($selectyear . '-01-01');
			$jourPremierJanvier = date('w', $timeStampPremierJanvier);

			//on se positionne sur la semaine demandé -1 car on part de la première semaine
			$timeStampDate = strtotime('+' . ($selectweek-1) . ' weeks', $timeStampPremierJanvier);
			//-- recherche du lundi de la semaine en fonction de la ligne précédente ---------
			$firstdayweek = ($jourPremierJanvier == 1) ?  $timeStampDate : strtotime('last monday', $timeStampDate);
			//print "firstdayweek=".date("d-m-Y", $firstdayweek)."<br>";

			// on ne décale pas si c'est un lundi, sinon on ajoute X jours -1
			if ($jourDateIntervention == 1)
				$newdayweek = $firstdayweek;
			else
				$newdayweek = strtotime(date("Y-m-d", strtotime(date('d-m-Y', $firstdayweek)))." +".($jourDateIntervention-1)." day"); 

			$newDateInter=dol_mktime(
				date("H", $dateIntervention),
				date("i", $dateIntervention), '00',
				date("m", $newdayweek),
				date("d", $newdayweek),
				date("Y", $newdayweek)
			);
			//print "newdateinter=".date("d-m-Y", $newDateInter)."<br>";
		} else {
			// on décale sur le mois demandé
			$newDateInter=dol_mktime(
				$dateIntervention->format("H"),
				$dateIntervention->format("i"), '00',
				$periodmonth,
				$dateIntervention->format("d"),
				$periodyearmonth
			);

		}
		$sql = "UPDATE ".MAIN_DB_PREFIX."fichinterdet";
		$sql .= " SET date = '".$db->idate($newDateInter)."'";
		$sql .= " WHERE rowid = ".$id;
		$resql = $db->query($sql);
		//print $sql;
	}

	echo json_encode($return);
}