<?php
/* Copyright (C) 2012 		Regis Houssin		<regis.houssin@capnetworks.com>
 * Copyright (C) 2016 		Laurent Destailleur	<eldy@users.sourceforge.net>
 * Copyright (C) 2018-2020	Charlene Benke		<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *       \file       myschdule/ficheinter/ajax/event-user.php
 *       \brief      File to load update an event
 */

if (! defined('NOTOKENRENEWAL')) define('NOTOKENRENEWAL','1'); // Disables token renewal
if (! defined('NOREQUIREMENU'))  define('NOREQUIREMENU','1');
//if (! defined('NOREQUIREHTML'))  define('NOREQUIREHTML','1');
if (! defined('NOREQUIREAJAX'))  define('NOREQUIREAJAX','1');
//if (! defined('NOREQUIRESOC'))   define('NOREQUIRESOC','1');
//if (! defined('NOREQUIRETRAN'))  define('NOREQUIRETRAN','1');

$res=0;
if (! $res && file_exists("../../../main.inc.php")) 
	$res=@include("../../../main.inc.php");		// For root directory
if (! $res && file_exists("../../../../main.inc.php")) 
	$res=@include("../../../../main.inc.php");	// For "custom" directory

dol_include_once('/core/lib/date.lib.php');
dol_include_once('/fichinter/class/fichinter.class.php');
dol_include_once('/myschedule/class/myschedule.class.php');


$userid = GETPOST('userid', 'int');
$fk_fichinter = GETPOST('fk_fichinter', 'int');
$id = GETPOST('id', 'int');
$duree = GETPOST('duree', 'int');
$unaffect = GETPOST("unaffect","int");

/*
 * View
 */
top_httphead();

//print '<!-- Ajax page called with url '.dol_escape_htmltag($_SERVER["PHP_SELF"]).'?'.dol_escape_htmltag($_SERVER["QUERY_STRING"]).' -->'."\n";

// Load original field value
if (! empty($userid) && ! empty($fk_fichinter)) {
	$fichinter_static= new FichInter($db);
	$fichinter_static->fetch($fk_fichinter);
	$fichinterdet_schedule_static = new fichinterdet_schedule($db);

	if ($unaffect == 1) {
		// on enleve l'utilisateur sélectionné
		$sql = "DELETE FROM ".MAIN_DB_PREFIX."element_contact";
		$sql .= " WHERE element_id =".$fk_fichinter;
		$sql .= " AND fk_socpeople =".$userid;
		$db->query($sql);

		$fichinterdet_schedule_static->delete(0, $userid, $id);
	} else {
		// ajoute l'utilisateur de l'intervention si il ne l'est pas déjà 
		$result = $fichinter_static->add_contact($userid, 121, 'internal');
		// si il y a une valeur pour la durée, on l'affecte à l'utilisateur que l'on vient de créer
		if ($duree != 0) {
			// on la supprime d'un ancien utilisateur si elle est déjà affecté
			// on affecte au nouvel utilisateur
			$fichinterdet_schedule_static->fk_user = $userid;
			$fichinterdet_schedule_static->fk_fichinterdet = $id;
			$fichinterdet_schedule_static->duration_planned = $duree;
			$fichinterdet_schedule_static->insert();
		}
	}



	echo json_encode($return);

}