<?php
/* Copyright (C) 2013-2021	Charlene BENKE	<charlene@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file	   	htdocs/myschedule/fichinter/fullcalendar.php
 *	\ingroup		myschedule
 *	\brief	  	Page of fichinter myschedule
 */

$res=@include("../../main.inc.php");					// For root directory
if (! $res && file_exists($_SERVER['DOCUMENT_ROOT']."/main.inc.php"))
	$res=@include($_SERVER['DOCUMENT_ROOT']."/main.inc.php"); // Use on dev env only
if (! $res) $res=@include("../../../main.inc.php");		// For "custom" directory

require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/fichinter/class/fichinter.class.php';
require_once DOL_DOCUMENT_ROOT.'/contact/class/contact.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';
require_once DOL_DOCUMENT_ROOT."/core/class/doleditor.class.php";

if ($conf->contrat->enabled) {
	require_once DOL_DOCUMENT_ROOT."/core/class/html.formcontract.class.php";
	require_once DOL_DOCUMENT_ROOT."/contrat/class/contrat.class.php";
}
if ($conf->projet->enabled) {
	require_once DOL_DOCUMENT_ROOT."/core/class/html.formprojet.class.php";
	require_once DOL_DOCUMENT_ROOT."/projet/class/project.class.php";
}

//require_once DOL_DOCUMENT_ROOT."/holiday/class/holiday.class.php";

dol_include_once('/myschedule/core/lib/myschedule.lib.php');
dol_include_once('/myschedule/class/myschedule.class.php');

$langs->load('companies');
$langs->load('interventions');
$langs->load('bills');
$langs->load('myschedule@myschedule');

$error=0;

$action	= GETPOST('action', 'alpha');
$choiceperiod= GETPOST('choiceperiod')?GETPOST('choiceperiod', 'alpha'):$conf->global->MYSCHEDULE_PeriodFilter;

$statutinter=GETPOST('statutinter', 'array');

$perioduser=GETPOST('perioduser', 'int');
if (!$perioduser)
if ($user->admin == 0 && $user->rights->myschedule->alluser == 0)
		$perioduser=$user->id;
	else
		$perioduser=-1;

$periodcontact=GETPOST('periodcontact')?GETPOST('periodcontact', 'int'):-1;

$periodsoc=GETPOST('periodsoc', 'int');
if ($periodsoc ==0 && ! empty($user->societe_id))
	$periodsoc = $user->societe_id;

$dolstatut=GETPOST('dolstatut')?GETPOST('dolstatut', 'int'):-1;

$periodyear=GETPOST('periodyear', 'int');

if (!$periodyear)
$periodyear=date('Y');

$periodyearmonth=GETPOST('periodyearmonth', 'int');
if (!$periodyearmonth)
	$periodyearmonth=date('Y');

$periodmonth=GETPOST('periodmonth', 'int');
if (! $periodmonth )
	$periodmonth=date('m');

$periodweek=GETPOST('periodweek', 'int');
if (!$periodweek)
	$periodweek=date('W');
if ($choiceperiod == 'week') {
	$firstdayweek = GETPOST("firstdayweek", "alpha");
	if ($firstdayweek == "") 
		$firstdayweek = firstdayweek($periodweek, $periodyear);
	else {
		// on détermine la bonne semaine
		$firstdayweek = strtotime($firstdayweek);
		$periodweek= date('W', $firstdayweek);

	}
//print "FDW=".$firstdayweek;
	$periodmonth=date('m', $firstdayweek);
	$lastdayweek = strtotime(date("Y-m-d", strtotime(date('d-m-Y', $firstdayweek)))." +6 day"); 

	$fullcalendarfirstday=date("Y-m-d", $firstdayweek);
	$fullcalendarlastday=date("Y-m-d", $lastdayweek);	
} 
if ($choiceperiod=='month') {
	$fullcalendarfirstday=date("Y-m-d", dol_mktime(0, 0, 0, $periodmonth, 1, $periodyearmonth));
	$fullcalendarlastday=date("Y-m-d", dol_mktime(0, 0, 0, $periodmonth, 30, $periodyearmonth));
} 

$startHourDay=convertSecondToTime($conf->global->MYSCHEDULE_startHourDay?$conf->global->MYSCHEDULE_startHourDay:2*3600, "allhourmin", 86400);
$endHourDay=convertSecondToTime($conf->global->MYSCHEDULE_endHourDay?$conf->global->MYSCHEDULE_endHourDay:23*3600, "allhourmin", 86400);
$startHourWork=convertSecondToTime($conf->global->MYSCHEDULE_startHourWork?$conf->global->MYSCHEDULE_startHourWork:9*3600, "allhourmin", 86400);
$endHourWork=convertSecondToTime($conf->global->MYSCHEDULE_endHourWork?$conf->global->MYSCHEDULE_endHourWork:20*3600, "allhourmin", 86400);


// Security check
if (! empty($user->societe_id))
	$socid=$user->societe_id;
$result = restrictedArea($user, 'ficheinter', "", 'fichinter');


/*
 * View
 */
$arrayofcss = array
	( '/myschedule/js/main.min.css'
);

$arrayofjs = array
	( '/myschedule/js/main.min.js'
	, '/myschedule/js/moment.min.js'
	, '/myschedule/js/locales/fr.js'
	, "https://cdn.ckeditor.com/ckeditor5/23.1.0/classic/ckeditor.js"
);

if ($action == "addFichInter") {

	// on crée l'intervention
	$object = new Fichinter($db);
	$objectLine = new FichinterLigne($db);
	$object->socid = GETPOST('periodsoc_add', 'int');;
	// si on a besoin de récupérer des infos dans le tiers
	if ($conf->global->MYSCHEDULE_tiersexfipubnote != "" || $conf->global->MYSCHEDULE_tiersexfiprivnote != "" ) {
		$societe_static= new Societe($db);
		$societe_static->fetch($object->socid);
		$tiersexfipubnote  = $societe_static->array_options["options_".$conf->global->MYSCHEDULE_tiersexfipubnote];
		$tiersexfiprivnote = $societe_static->array_options["options_".$conf->global->MYSCHEDULE_tiersexfiprivnote];
	}
	$object->fk_project	 = GETPOST('projectid-add', 'int');
	$object->fk_contrat	 = GETPOST('contratid-add', 'int');
	$object->author		 = $user->id;
	$object->description = GETPOST('description-add', 'text');

	$object->modelpdf = $conf->global->FICHEINTER_ADDON_PDF;
	
	$object->note_private = ($tiersexfiprivnote?$tiersexfiprivnote."\n":"").GETPOST('note_private-add', 'text');
	$object->note_public = ($tiersexfipubnote?$tiersexfipubnote."\n":"").GETPOST('note_public-add', 'text');
	$result = $object->create($user);

	if ($result > 0) {
		$object->id = $result; // Force raffraichissement sur fiche venant d'etre cree
		$object->fetch($object->id);
	} else {
		// si on a merdé on affiche...
		setEventMessages($object->error, $object->errors, 'errors');
	}

	$fichinterdet_schedule_static = new fichinterdet_schedule($db);
	// si la description de la ligne d'inter est vide, on ne la crée pas
	for ($i=1;$i<=$conf->global->MYSCHEDULE_nbnewlineinter;$i++) {
		$desc = GETPOST('np_desc-add-'.$i, 'text');
		if ($desc !="") {
			$date_intervention = dol_mktime(
				GETPOST('dateo-add-'.$i.'hour', 'int'), 
				GETPOST('dateo-add-'.$i.'min', 'int'), 0, 
				GETPOST('dateo-add-'.$i.'month', 'int'), 
				GETPOST('dateo-add-'.$i.'day', 'int'), 
				GETPOST('dateo-add-'.$i.'year', 'int')
			);

			$duration = convertTime2Seconds(
				GETPOST('duration-add-'.$i.'hour', 'int'), 
				GETPOST('duration-add-'.$i.'min', 'int')
			);

			$objectLine->fk_fichinter = $object->id;
			$objectLine->desc = $desc;
			$objectLine->datei = $date_intervention;
			$objectLine->duration = $duration;
			$result = $objectLine->insert($user);
			$fk_fichinterdet = $objectLine->id;

			// si on a un sélectionné un contact
			$contactid = GETPOST('userid-add-'.$i, 'int');
			if ($contactid > 0) {
				// on attache le contact à l'intervention
				$result = $object->add_contact($contactid, 121, 'internal');
				if( GETPOST('userid-chk-'.$i, 'int')) {
					// on affecte le temps de l'inter dans le shedule
					$fichinterdet_schedule_static->fk_user = $contactid;
					$fichinterdet_schedule_static->fk_fichinterdet = $fk_fichinterdet;
					$fichinterdet_schedule_static->duration_planned = $duration;
					$ret = $fichinterdet_schedule_static->insert();
				}
			}
		}
	}
	// on récupère la liste des contacts récupéré
	$contactList=GETPOST("add_add_contact", "array");
	// add
	foreach($contactList as $contactToAdd) {
		// on attache le contact à l'intervention
		$result = $object->add_contact($contactToAdd, 131, 'external');
	}
}

if ($action == "editfichinter") {
	// on récup l'id de l'intervention et de la ligne d'inter
	$fk_fichinter=GETPOST("fk_fichinter", "int");
	$fk_fichinterdet=GETPOST("fk_fichinterdet", "int");
	$object = new Fichinter($db);
	$object->fetch($fk_fichinter);

	// mise à jour des infos de l'inter native
	$object->description	= GETPOST('description_edit', 'alpha');
	$object->note_public	= GETPOST("note_public_edit", "alpha");
	$object->note_private	= GETPOST("note_private_edit", "alpha");
	$object->fk_project		= GETPOST('fk_project_edit', 'int');

	$result = $object->update($user);
	if ($result < 0) {
		setEventMessages($object->error, $object->errors, 'errors');
	}

	// mise à jour du reste des infos (non prise en charge par l'update natif)
	$object->socid = GETPOST("fk_soc_edit", "int");
	$object->fk_contrat = GETPOST('fk_contrat_edit', 'int');
	$object->statut = GETPOST('fk_statut_edit', 'int');

	// si on change le statut (si avant brouillon) pour déterminer la ref
	if (preg_match('/^[\(]?PROV/i', $object->ref) && GETPOST("fk_statut_edit", "int") > 0 )
		$object->setValid($user);
	
	$sql = "UPDATE ".MAIN_DB_PREFIX."fichinter SET ";
	$sql .= "fk_soc = ".$object->socid;
	$sql .= ", fk_contrat = ".($object->fk_contrat?$object->fk_contrat:'null');
	$sql .= ", fk_statut = ".$object->statut;
	$sql .= " WHERE rowid = ".$fk_fichinter;
	$db->query($sql);

	// mise à jour de la ligne de détail de l'inter
	$objectLine = new FichinterLigne($db);
	$objectLine->fetch($fk_fichinterdet);

	$objectLine->desc = GETPOST('np_desc_edit', 'alpha');
	$objectLine->datei = dol_mktime(
		GETPOST('dateo-edithour', 'int'), GETPOST('dateo-editmin', 'int'), 0, 
		GETPOST('dateo-editmonth', 'int'), GETPOST('dateo-editday', 'int'), GETPOST('dateo-edityear', 'int')
	);
	$objectLine->duration = convertTime2Seconds(GETPOST('duration-edithour', 'int'), GETPOST('duration-editmin')?GETPOST('duration-editmin', 'int'):0);
	$objectLine->update($user);

	// gestion des données de schéduling
	$schedule_static= new fichinterdet_schedule($db);
	// par principe on supprime les anciennes lignes et on ajoute ce qu'il y a de saisie
	$schedule_static->delete(0, 0, $fk_fichinterdet);
	// récup des id des contacts
	$contactArray = explode(",", substr(GETPOST("userlist", "alpha"), 0, -1));
	$idBloc=1;
	foreach($contactArray as $contactUser) {
		// si l'utilisateur n'est pas à supprimer
		if (GETPOST("chkDelUser-".$idBloc, "int") != 1) {
			$schedule_static->fk_user = $contactUser;
			$schedule_static->fk_fichinterdet = $fk_fichinterdet;
			$schedule_static->duration_planned = convertTime2Seconds(
					GETPOST('planned-'.$idBloc.'hour', 'int'), GETPOST('planned-'.$idBloc.'min', 'int')
			);
			$schedule_static->duration_made =convertTime2Seconds(
					GETPOST('made-'.$idBloc.'hour', 'int'), GETPOST('made-'.$idBloc.'min', 'int')
			);
			$schedule_static->insert();
		} else {
			// on regarde si l'user a encore des temps sur cette inter, si vide on l'enleve
			$tbleTimeUser = $schedule_static->fetch_all(0, $contactUser, $fk_fichinter);
			if (count($tbleTimeUser)==0) {
				$sql = "DELETE FROM ".MAIN_DB_PREFIX."element_contact";
				$sql .= " WHERE element_id = ".$fk_fichinter;
				$sql .= " AND fk_socpeople = ".$contactUser;
				$db->query($sql);
			}
		}
		$idBloc++;
	}
	// on regarde si on doit ajouter l'user à inter
	$newuserID = GETPOST("newuser-0", "int");
	if ($newuserID > 0 ) {
		// on  rajoute l'user (et si ca plante car doubon pas grave)
		$result = $object->add_contact($newuserID, 121, 'internal');
		// et enfin les temps
		$schedule_static->fk_user = $newuserID;
		$schedule_static->fk_fichinterdet = $fk_fichinterdet;
		$schedule_static->duration_planned = convertTime2Seconds(
				GETPOST('planned-0hour', 'int'), GETPOST('planned-0min', 'int')
		);
		$schedule_static->duration_made =convertTime2Seconds(
			GETPOST('made-0hour', 'int'), GETPOST('made-0min', 'int')
		);
		$schedule_static->insert();
	}

	// GESTION DES CONTACTS EXTERNES
	$contactListOld = GETPOST("contactlist", "alpha");
	$contactListNew = GETPOST("add_edit_contact", "array");
	
	// on supprime les contacts externes
	$sql = "DELETE FROM ".MAIN_DB_PREFIX."element_contact";
	$sql .= " WHERE element_id = ".$fk_fichinter;
	$sql .= " AND fk_c_type_contact = 131";
	$db->query($sql);

	// récupèration des anciens contacts 
	if ($contactListOld) {
		$contactArrayOld = explode(",", substr($contactListOld, 0, -1));
		foreach($contactArrayOld as $contactToAdd) {
			// on attache le contact à l'intervention
			$result = $object->add_contact($contactToAdd, 131, 'external');
		}
	}
	// ajout des nouveaux 
	if (count($contactListNew) >0) {
		foreach($contactListNew as $contactToAdd) {
			// on attache le contact à l'intervention
			$result = $object->add_contact($contactToAdd, 131, 'external');
		}
	}
}

if ($action == "deleteinter") {
	$fk_fichinter=GETPOST("fk_fichinter", "int");
	$fk_fichinterdet=GETPOST("fk_fichinterdet", "int");

	// suppression de la ligne d'intervention
	$sql= " DELETE FROM ".MAIN_DB_PREFIX."fichinterdet";
	$sql.= " WHERE rowid =".$fk_fichinterdet;
	$resql = $db->query($sql);
	//$return['query']=$sql;

	// on regarde si il reste des lignes d'inter à la fiche d'inter
	$sql= "SELECT rowid FROM ".MAIN_DB_PREFIX."fichinterdet";
	$sql.= " WHERE fk_fichinter =".$fk_fichinter;

	$resql = $db->query($sql);
	$num = $db->num_rows($resql);
	if ($num == 0) {
		// si plus de ligne d'inter on supprime la fiche d'intervention aussi
		$sql= " DELETE FROM ".MAIN_DB_PREFIX."fichinter";
		$sql.= " WHERE rowid =".$fk_fichinter;
		$resql = $db->query($sql);
	}
}

$help_url="https://wiki.patas-monkey.com/index.php?title=MySchedule#Ecran_principal";
$title=$langs->trans("mySchedule");
llxHeader('', $title, $help_url, '', 0, 0, $arrayofjs, $arrayofcss, '');


$form = new Form($db);
$formother = new FormOther($db);

if ($conf->contrat->enabled) $formcontract = new FormContract($db);
if ($conf->projet->enabled) $formprojet = new FormProjets($db);

$now=dol_now();

/*
 * Show object in view mode
 */

print load_fiche_titre($title, "", 'myschedule@myschedule');
$showempty=1;
print '<form method="POST" action="fullcalendar.php">';
print '<table class="noborder noborderbottom" >';
print '<tr class="liste_titre">';
print '<th align=left colspan=4 >'.$langs->trans("Filters").'</th>';
print "</tr>\n";

print '<tr >';
print '<td valign=top>';
print '<table >';
print '<tr><td></td></tr>';
print '<tr><td><input type=radio '.($choiceperiod=="week"?"checked":"").' name=choiceperiod value="week"></td><td>';
print $formother->selectyear($periodyear, 'periodyear');
print select_week($periodweek, 'periodweek');
print '</td></tr>';
print '<tr><td><input type=radio '.($choiceperiod=="month"?"checked":"").' name=choiceperiod value="month"></td><td>';
print $formother->selectyear($periodyearmonth, 'periodyearmonth');
print $formother->select_month($periodmonth, 'periodmonth', 0, 1, "");
print '</td></tr>';
print '</table>';
print '</td>';

// filtre sur l'intervention
print '<td valign=top>';
print '<table>';
print "<tr><td>".$langs->trans("Ref")."</td><td>";
print "<input type=text name=search_ref value='".$search_ref."'>";
print "</td></tr>";


// on ne voit que ses intervention ou celle des collabs dont on est le suppérieur
$filteruser="";
if ($user->admin == 0 && $user->rights->myschedule->alluser == 0)
	$filteruser=" AND (u.rowid = ".$user->id." OR fk_user=".$user->id.")";
print '<tr><td>'.$langs->trans("Users")."</td><td>"; 
print $form->select_dolusers(
			$perioduser, 'perioduser', $showempty,
			'', 0, '', '', 0, 0, 0, $filteruser
);
print "</td></tr>";

print "<tr><td>".$langs->trans("ThirdParty")."</td><td>";
print $form->select_company($periodsoc, 'periodsoc', '', $showempty, 0, 0, array(), 0, 'minwidth400');
print "</td></tr>";

$showFonction=0;
$showSoc=1;
print '<tr><td>'.$langs->trans("Contact")."</td><td>"; 
print $form->selectcontacts(0, $periodcontact, 'periodcontact', $showempty, '', '',  $showFonction, '',  false, $showSoc);
print "</td></tr>";

print '</table>';
print '</td>';

print '<td valign=top align=right>';
print '<table width=100%>';
print '<tr><td bgcolor="'.$conf->global->MYSCHEDULE_colornouser.'" title="'.$langs->trans("InfoNoUserAffected").'">';
print '<input name="statutinter[]" value="nouser"  '.(in_array("nouser", $statutinter)?" checked ":0).' type=checkbox>';
print $langs->trans("NoUserAffected")."</td>\n";
print '<td bgcolor="'.$conf->global->MYSCHEDULE_colornotmade.'" title="'.$langs->trans("InfoNotYetMade").'">';
print '<input name="statutinter[]" value="notyetmade"  '.(in_array("notmade", $statutinter)?" checked ":0).' type=checkbox>';
print $langs->trans("NotYetMade")."</td></tr>\n";
print '<tr><td bgcolor="'.$conf->global->MYSCHEDULE_colornotplanned.'" title="'.$langs->trans("InfoNotYetPlanned").'">';
print '<input name="statutinter[]" value="notplanned" '.(in_array("notplanned", $statutinter)?" checked ":0).' type=checkbox>';
print $langs->trans("NotYetPlanned")."</td>\n";
print '<td bgcolor="'.$conf->global->MYSCHEDULE_colormade.'" title="'.$langs->trans("InfoMade").'">';
print '<input name="statutinter[]" value="made" '.(in_array("made", $statutinter)?" checked ":0).' type=checkbox>';
print  $langs->trans("Made")."</td></tr>\n";
print '<tr><td></td></tr>';

print "<tr><td align=left>".$langs->trans("Status")." : ";
$statutArray = array(
	'0'=>$langs->trans('Draft'), 
	'1'=>$langs->trans('Validate'),
	'2'=>$langs->trans('StatusInterInvoiced'),
	'3'=>$langs->trans('Closed')
);
print $form->selectarray('dolstatut', $statutArray, $dolstatut, $showempty );
print "</td><td align=right>";
print '<input type=submit class="button" name="select" value="'.$langs->trans("Search").'">';
print "</td></tr>";
print "</table>";
print '</td>';
print '<td valign=bottom align=right>';

print "</td>";
print "</tr>\n";
print "</table>";
print '</form>';
print '<br>';
print "<div id='calendar' ></div>";
print "<script>";

print "document.addEventListener('DOMContentLoaded', function() {"."\n";
print "var calendarEl = document.getElementById('calendar');"."\n";
print "var calendar = new FullCalendar.Calendar(calendarEl, {"."\n";
print "locale: 'fr',\n";
if ($choiceperiod == 'week')
	print "dayHeaderFormat: {weekday: 'long', day: '2-digit', month : '2-digit'},\n";
else
	print "dayHeaderFormat: {weekday: 'long'},\n";
print "timeZone: 'UTC',\n";
print "editable: true,\n";
print "themeSystem: 'standard',\n";
print "droppable: true,\n";
print "fixedWeekCount: false,\n";

print "slotMinTime: '".$startHourDay."',\n";
print "scrollTime: '".$startHourWork."',\n";
print "slotMaxTime: '".$endHourDay."',\n";
print "businessHours: {\n";
print "	daysOfWeek: [ 1, 2, 3, 4, 5 ],\n"; // Monday - Thursday
print "startTime: '".$startHourWork."',\n"; // a start time (10am in this example)
print "endTime: '".$endHourWork."',\n"; // an end time (6pm in this example)
print "},\n";

// ouverture du popup de création
print "dateClick: function(info) {\n";
print  '$( "#tabsdialogadd" ).tabs();'."\n";

print '$( "#dialog-addfichinter" ).dialog({';
print 'modal: true,';
print '	buttons: [
	{	text: "'.$langs->transnoentities("Save").'",
		icons: { primary: "ui-icon-check" },
		click: function() 
		{ 
			// TODO ajouter le controle de la saisie 
			// présence du tiers
			if ($("#periodsoc_add").val() == -1) {
				alert("'.$langs->transnoentities("ThirdpartyObligatory").'");
				exit;
			}'."\n";
			// on vérifie la présence d'une description de ligne d'intervention 
			// voir avec le wisiwig ce qu'il faut tester?
			print "bDescDetAbsente = true;\n";

			print 'if (bDescDetAbsente) {
			//	alert("'.$langs->transnoentities("DescDetObligatory").'");
			//	exit;
			}
			// si tout est ok on valide la creation
			$("#addfichinter").submit(); 
		}
	}'."\n";
print '],'."\n";
print "width: 900,\n";
print "height: 530,\n";
print '});';
// on met en forme les dates
for ($i=1;$i<=$conf->global->MYSCHEDULE_nbnewlineinter;$i++){
	print '$("#dateo-add-'.$i.'").val(moment.utc(info.dateStr).format("DD/MM/YYYY"));';
	print '$("#dateo-add-'.$i.'day").val(moment.utc(info.dateStr).format("DD"));';
	print '$("#dateo-add-'.$i.'month").val(moment.utc(info.dateStr).format("MM"));';
	print '$("#dateo-add-'.$i.'year").val(moment.utc(info.dateStr).format("YYYY"));'."\n";
	if ($choiceperiod == 'week') {
		print '$("#dateo-add-'.$i.'hour").val(moment.utc(info.dateStr).format("HH"));';
		print '$("#dateo-add-'.$i.'min").val(moment.utc(info.dateStr).format("mm"));';	

	} else {
		// on alimente avec l'heure de début de travail si on est sur le mois
		// voir si par la suite on permet de sélectionner avec l'heure en cours, debut de journée ou de travail
		print '$("#dateo-add-'.$i.'hour").val("'.substr($startHourWork,0,2).'");';
		print '$("#dateo-add-'.$i.'min").val("'.substr($startHourWork,3,2).'");';	
	}
}
print "},\n";

print "initialDate: '".$fullcalendarfirstday."',\n";

// selection du mode d'affichage de full calendar
switch($choiceperiod) {
	case "week":
		print "initialView: 'timeGridWeek',\n";
		print "allDaySlot: false,\n";
	break;
	case "month":
		print "initialView: 'dayGridMonth',"."\n";
		print "weekNumbers: true,\n";
	break;
}

// ajout des boutons d'actions du header
print "customButtons: {\n";
// création de l'url commune du filtre
$urlPeriodFilter = "&filterbystatut=".implode(",", $statutinter);
$urlPeriodFilter.= "&dolstatut=".$dolstatut;
if ($periodsoc > 0)
	$urlPeriodFilter.= "&periodsoc=".$periodsoc;
if ($perioduser > 0)
	$urlPeriodFilter.= "&perioduser=".$perioduser;
if ($periodcontact > 0)
	$urlPeriodFilter.= "&periodcontact=".$periodcontact;


print "  delButton: {\n"; //  suppression
print "text: '".$langs->transnoentities('MassDelete')."',\n";
print "click: function() {\n";
print "window.open('".dol_buildpath("/myschedule/fichinter/", 1);
print "massdelete.php?choiceperiod=".$choiceperiod;
print "&periodyear=".$periodyear."&periodweek=".$periodweek."&periodmonth=".$periodmonth;
print $urlPeriodFilter."', '_self');\n";
print "}}\n";

print ", changeUserButton: {\n"; // changement d'user
print "text: '".$langs->transnoentities('MassChangeUser')."',\n";
print "click: function() {\n";
	print "window.open('".dol_buildpath("/myschedule/fichinter/", 1);
	print "massuser.php?choiceperiod=".$choiceperiod;
	print "&periodyear=".$periodyear."&periodweek=".$periodweek."&periodmonth=".$periodmonth;
	print $urlPeriodFilter."', '_self');\n";
print "}}\n";

print ", plannedButton: {\n"; // changement d'user
print "text: '".$langs->transnoentities('MassPlanification')."',\n";
print "click: function() {\n";
	print "window.open('".dol_buildpath("/myschedule/fichinter/", 1);
	print "massplanification.php?choiceperiod=".$choiceperiod;
	print "&periodyear=".$periodyear."&periodweek=".$periodweek."&periodmonth=".$periodmonth;
	print $urlPeriodFilter."', '_self');\n";
print "}}\n";

print ", jobMadeButton: {\n"; // changement d'user
print "text: '".$langs->transnoentities('MassJobMade')."',\n";
print "click: function() {\n";
	print "window.open('".dol_buildpath("/myschedule/fichinter/", 1);
	print "massjobmade.php?choiceperiod=".$choiceperiod;
	print "&periodyear=".$periodyear."&periodweek=".$periodweek."&periodmonth=".$periodmonth;
	print $urlPeriodFilter."', '_self');\n";
print "}}\n";
		
print ", cloneButton: {\n"; // clonage des lignes d'inter
print "text: '".$langs->transnoentities('MassClone')."',\n";
print "click: function() {\n";
	print "window.open('".dol_buildpath("/myschedule/fichinter/", 1);
	print "massclone.php?choiceperiod=".$choiceperiod;
	print "&periodyear=".$periodyear."&periodweek=".$periodweek."&periodmonth=".$periodmonth;
	print $urlPeriodFilter."', '_self');\n";
print "}}\n";

print ", shiftButton: {\n"; // décalage des inter sur une autre semaine
print "text: '".$langs->transnoentities('MassShift')."',\n";
print "click: function() {\n";
	print "window.open('".dol_buildpath("/myschedule/fichinter/", 1);
	print "massshift.php?choiceperiod=".$choiceperiod;
	print "&periodyear=".$periodyear."&periodweek=".$periodweek."&periodmonth=".$periodmonth;
	print $urlPeriodFilter."', '_self');\n";
print "}}\n";

print ", statutButton: {\n"; // changement en masse des statut dolibarr
print "text: '".$langs->transnoentities('MassStatut')."',\n";
print "click: function() {\n";
	print "window.open('".dol_buildpath("/myschedule/fichinter/", 1);
	print "massstatut.php?choiceperiod=".$choiceperiod;
	print "&periodyear=".$periodyear."&periodweek=".$periodweek."&periodmonth=".$periodmonth;
	print $urlPeriodFilter."', '_self');\n";
print "}}\n";

// Boutons de navigation simplifié
print ", weekButton: {\n";
print "text: '".$langs->transnoentities('Week')." ".$periodweek."',\n";
print "click: function() {\n";
// appel de la page de décallage
print "window.open('".dol_buildpath("/myschedule/fichinter/", 1);
print "fullcalendar.php?choiceperiod=week";
print "&periodyear=".$periodyear;
print "&periodweek=".$periodweek;
print $urlPeriodFilter."', '_self');\n";
print "}}\n";

print ", prevWeekButton: {\n";
print "icon: 'chevron-left',\n";
print "click: function() {\n";
// appel de la page de décallage
print "window.open('".dol_buildpath("/myschedule/fichinter/", 1);
print "fullcalendar.php?choiceperiod=week";
if ($periodweek == 1) {
	print "&periodyear=".((int)$periodyear-1);
	print "&periodweek=52"; // gérer la blague avec 52/53	
} else {
	print "&periodyear=".$periodyear;
	print "&periodweek=".((int)$periodweek-1);
}
print $urlPeriodFilter."', '_self');\n";
print "}}\n";

print ", nextWeekButton: {\n";	
print "icon: 'chevron-right',\n";
print "click: function() {\n";
// on affiche la semaine suivante
print "window.open('".dol_buildpath("/myschedule/fichinter/", 1);
print "fullcalendar.php?choiceperiod=week";
if ($periodweek >= 52) { // gérer la blague avec 52/53
	print "&periodyear=".((int)$periodyear+1);
	print "&periodweek=1";	
} else {
	print "&periodyear=".$periodyear;
	print "&periodweek=".((int)$periodweek+1);
}
print $urlPeriodFilter."', '_self');\n";
print "}}\n";

print ", monthButton: {\n";
print "text: '".$langs->transnoentities('Month'.$periodmonth)."',\n";
print "click: function() {\n";
// on affiche le mois
print "window.open('".dol_buildpath("/myschedule/fichinter/", 1);
print "fullcalendar.php?choiceperiod=month";
print "&periodyear=".$periodyear;
print "&periodmonth=".$periodmonth;
print $urlPeriodFilter."', '_self');\n";
print "}}\n";

print ", monthNextButton: {\n";
print "text: '".$langs->transnoentities('Month'.((int)$periodmonth+1))."',\n";
print "click: function() {\n";
// appel de la page de décallage
print "window.open('".dol_buildpath("/myschedule/fichinter/", 1);
print "fullcalendar.php?choiceperiod=month";
print "&periodyear=".$periodyear;
print "&periodmonth=".((int)$periodmonth+1);
print $urlPeriodFilter."', '_self');\n";
print "}}\n";

print ", prevMonthButton: {\n";
print "icon: 'chevron-left',\n";
print "click: function() {\n";
// appel de la page de décallage
print "window.open('".dol_buildpath("/myschedule/fichinter/", 1);
print "fullcalendar.php?choiceperiod=month";
if ($periodmonth == 1) {
	print "&periodyear=".((int)$periodyear-1);
	print "&periodmonth=12";	
} else {
	print "&periodyear=".$periodyear;
	print "&periodmonth=".((int)$periodmonth-1);
}
print $urlPeriodFilter."', '_self');\n";
print "}}\n";

print ", nextMonthButton: {\n";	
print "icon: 'chevron-right',\n";
print "click: function() {\n";
// appel de la page de décallage
print "window.open('".dol_buildpath("/myschedule/fichinter/", 1);
print "fullcalendar.php?choiceperiod=month";
if ($periodmonth == 12) {
	print "&periodyear=".((int)$periodyear+1);
	print "&periodmonth=1";	
} else {
	print "&periodyear=".$periodyear;
	print "&periodmonth=".((int)$periodmonth+1);
}
print $urlPeriodFilter."', '_self');\n";
print "}}\n";
print "},\n";


print "headerToolbar: {\n";
if( $choiceperiod == "week")
	print "start: 'monthButton prevWeekButton weekButton nextWeekButton monthNextButton',\n";
elseif( $choiceperiod == "month")
	print "start: 'prevMonthButton monthButton nextMonthButton',\n";
else
	print "start: '',\n";
print "end: 'changeUserButton,plannedButton,jobMadeButton statutButton,shiftButton,cloneButton delButton'\n";
print "  },\n";

// on click sur le numéro de la semaine de la vue mois, passe sur la semaine directement
print "navLinks: true,\n";
print " navLinkWeekClick: function(weekStart, jsEvent) {\n";
print " var firstdayweek = weekStart.toISOString();\n";
print "window.open('".dol_buildpath("/myschedule/fichinter/", 1);
print "fullcalendar.php?choiceperiod=week";
print "&periodyear=".$periodyear;
print "&firstdayweek='+firstdayweek+'";
print $urlPeriodFilter;
print "', '_self');\n";
print "},\n";

// pour désactiver le click sur le jours
//print " navLinkDayClick: function(date, jsEvent) {\n";
//print "},\n";

	
// modification de le durée de l'évènement
print "	eventResize:function(info) {\n";
print "	var start = moment.utc(info.event.start).format('YYYY-MM-DDTHH:mm');\n";
print "	var end = moment.utc(info.event.end).format('YYYY-MM-DDTHH:mm');\n";
print "	var title = info.event.title;\n";
print "	var id = info.event.id;\n";
print "	$.ajax({\n";
print "url: '".dol_buildpath("/myschedule/fichinter/ajax/", 1);
print "events-update.php',\n";
print "	type:'POST',\n";
print "	data:{title:title, start:start, end:end, id:id},\n";
print "complete : function(result, statut){\n";
	 print "calendar.refetchEvents();\n";
print "}\n";
print "	})\n";
print "	},\n";

// fonction de déplacement
print "	eventDrop:function(info) {\n";
print "	var start =  moment.utc(info.event.start).format('YYYY-MM-DDTHH:mm');\n";
print "	var end =  moment.utc(info.event.end).format('YYYY-MM-DDTHH:mm');\n";
print "	var title = info.event.title;\n";
print "	var id = info.event.id;\n";
print "	$.ajax({\n";
print "url: '".dol_buildpath("/myschedule/fichinter/ajax/", 1);
print "events-update.php',\n";
print "	type:'POST',\n";
print "	data:{title:title, start:start, end:end, id:id},\n";
print "complete : function(result, statut){\n";
	print "calendar.refetchEvents();\n";
print "}\n";
print "	})\n";
print "	},\n";


// popup d'ouverture en modif, bon c'est pas du léger
print "eventClick: function(info) {\n"; 
// on met en forme les onglets
print  '$( "#tabsdialogfc" ).tabs();'."\n";

//  on alimente la popup avec les info de l'évent
print '$( "#dialog-editfichinter" ).dialog({';
print 'modal: true,';
print "width: 850,\n";
print "height: 550,\n";
print '	buttons: ['."\n";
// ouverture en mode classique de l'inter
// voir si on ouvre l'inter directement ou sur un nouvel onglet
if (empty($conf->global->MYSCHEDULE_openonothertab)) {
	print '{
		text: "'.$langs->transnoentities("ClassicEditMode").'",
		icons: { primary: "ui-icon-arrow-4-diag" },
		click: function() {
			window.open(info.event.extendedProps.classicediturl, "_self");
		}
	},'."\n";
} else {
	print '{
		text: "'.$langs->transnoentities("ClassicEditMode").'",
		icons: { primary: "ui-icon-extlink" },
		click: function() {
			window.open(info.event.extendedProps.classicediturl);
		},
	},'."\n";
}

// entregistrement de l'inter 
print '{	
	text: "'.$langs->transnoentities("Save").'",
	icons: { primary: "ui-icon-check" },
	click: function() {
		// on ajoute le controle de la saisie 
		$("#editfichinter").submit();
	}
},'."\n";

print '{	
	text: "'.$langs->transnoentities("Delete").'",
	icons: { primary: "ui-icon-trash" },
	click: function() {
		// validation et suppression
		$("#actionedit").val("deleteinter");
		$("#editfichinter").submit();
	},
	style: "color:red;font-weight:bold;"
}'."\n";

print '],'."\n";

// on alimente les données de l'inter
print "open : function() {\n";
print "iee = info.event.extendedProps;\n";
// on mémorise l'id de l'inter et celui de la ligne de détail 
print '$("#fk_fichinter").val(iee.fk_fichinter)'.";\n";
print '$("#fk_fichinterdet").val(info.event.id)'.";\n";

print "title='".$langs->transnoentities("EditFichinter")." '+iee.ref;\n";

print 'if(info.event.backgroundColor == "#'.$conf->global->MYSCHEDULE_colornouser.'")'."\n";
print '    title = title + " - '.$langs->trans("NoUserAffected").'"'."\n";

print 'if(info.event.backgroundColor == "#'.$conf->global->MYSCHEDULE_colornotmade.'")'."\n";
print '    title = title + " - '.$langs->trans("NotYetMade").'"'."\n";

print 'if(info.event.backgroundColor == "#'.$conf->global->MYSCHEDULE_colornotplanned.'")'."\n";
print '    title = title + " - '.$langs->trans("NotYetPlanned").'"'."\n";

print 'if(info.event.backgroundColor == "#'.$conf->global->MYSCHEDULE_colormade.'")'."\n";
print '    title = title + " - '.$langs->trans("Made").'"'."\n";

print '$(".ui-dialog-title").html(title)'.";\n";
print '$(".ui-dialog-titlebar").css("background", info.event.backgroundColor)'.";\n";

print '$("#description_edit").val(iee.fi_description)'.";\n";

print '$("#fk_soc_edit").val(iee.fk_soc);'."\n";
print '$("#fk_soc_edit").trigger("change");'."\n"; 
print '$("#search_fk_soc_edit").val(iee.socname);'."\n"; 
print '$("#search_fk_soc_edit").trigger("change");'."\n"; 

print '$("#fk_contrat_edit").val(iee.fk_contract);'."\n";
print '$("#fk_contrat_edit").trigger("change");'."\n"; 

print '$("#fk_statut_edit").val(iee.fk_statut);'."\n";
print '$("#fk_statut_edit").trigger("change");'."\n"; 
print "window.note_public_edit.setData(iee.note_public);\n";
print "window.note_private_edit.setData(iee.note_private);\n";
print "window.np_desc_edit.setData(iee.description);\n";

print '$("#np_desc_edit").val(iee.description)'.";\n";

// gestion du badge des notes
print "nbNote = 0\n";
print "if ( iee.note_private != '') nbNote = 1;\n";
print "if ( iee.note_public != '') nbNote = nbNote +1;\n";
print "if (nbNote == 0) {\n";
print "    $('#badge-tab-note').hide();\n";
print "} else {\n";
print "    $('#badge-tab-note').html(nbNote);\n";
print "    $('#badge-tab-note').show();\n";
print "}";


// alimentation de la date de début
print '$("#dateo-edit").val(iee.startday+"/"+iee.startmonth+"/"+iee.startyear)'.";\n";
print '$("#dateo-edit").trigger("change");'."\n"; 

print '$("#dateo-editday").val(iee.startday)'.";\n";
print '$("#dateo-editday").trigger("change");'."\n"; 
print '$("#dateo-editmonth").val(iee.startmonth)'.";\n";
print '$("#dateo-editmonth").trigger("change");'."\n"; 
print '$("#dateo-edityear").val(iee.startyear)'.";\n";
print '$("#dateo-edityear").trigger("change");'."\n"; 

print '$("#dateo-edithour").val(iee.starthour)'.";\n";
print '$("#dateo-edithour").trigger("change");'."\n"; 
print '$("#dateo-editmin").val(iee.startmin)'.";\n";
print '$("#dateo-editmin").trigger("change");'."\n"; 

print '$("#select_duration-edithour").val(iee.dureehour)'.";\n";
print '$("#select_duration-edithour").trigger("change");'."\n"; 
print '$("#select_duration-editmin").val(iee.dureemin)'.";\n";
print '$("#select_duration-editmin").trigger("change");'."\n"; 

// boucle sur les utilisateur associé à l'intervention
print 'for(i=1 ; i <= 4 ; i++) {'."\n";
// on affiche tout les users
print "    $('#box-user-'+i).hide();\n";
print "}\n";
print "i=0;\n";

print "userArray = iee.userArray\n";
print "$('#userlist').val('')\n";	
print "if (userArray != null) {\n";
// on vide la zone pour la remplir ensuite
print "    $.each(userArray, function(id, objuser) {\n";
	print "    i=i+1;\n";
	print "    $('#userlist').val($('#userlist').val()+id+',')\n";	

	print "    $('#box-user-'+i).show();\n";
	// on change le nom 
	print "    $('#username-'+i).html(objuser.name);\n";
	// on alimente les temps
	print "    $('#select_planned-'+i+'hour').val(objuser.plannedhour);\n";
	print "    $('#select_planned-'+i+'hour').trigger('change');\n";
	print "    $('#select_planned-'+i+'min').val(objuser.plannedmin);\n";
	print "    $('#select_planned-'+i+'min').trigger('change');\n";

	print "    $('#select_made-'+i+'hour').val(objuser.madehour);\n";
	print "    $('#select_made-'+i+'hour').trigger('change');\n";
	print "    $('#select_made-'+i+'min').val(objuser.mademin);\n";
	print "    $('#select_made-'+i+'min').trigger('change');\n";

	// selon le temps saisie on change la couleur
	print "if (objuser.plannedhour+objuser.plannedmin+objuser.madehour+objuser.mademin==0) {\n";
	print "    $('#info-box-content-'+i).css('background-color', '#".$conf->global->MYSCHEDULE_colornotplanned."');\n";
	print "    $('#box-icon-'+i).css('color', '#".$conf->global->MYSCHEDULE_colornotplanned."');\n";
	print "} else if (objuser.plannedhour+objuser.plannedmin>0 && objuser.madehour+objuser.mademin==0) {\n";
	print "    $('#info-box-content-'+i).css('background-color', '#".$conf->global->MYSCHEDULE_colornotmade."');\n";
	print "    $('#box-icon-'+i).css('color', '#".$conf->global->MYSCHEDULE_colornotmade."');\n";
	print "} else if (objuser.plannedhour+objuser.plannedmin>0 && objuser.madehour+objuser.mademin>0) {\n";
	print "    $('#info-box-content-'+i).css('background-color', '#".$conf->global->MYSCHEDULE_colormade."');\n";
	print "    $('#box-icon-'+i).css('color', '#".$conf->global->MYSCHEDULE_colormade."');\n";
	print "} else console.log(objuser.plannedhour+objuser.plannedmin+objuser.madehour+objuser.mademin);\n";
print "    });\n";
print "};\n";

// on met à jour le badge
print "if (i == 0) {\n";
print "    $('#badge-tab').hide();\n";
print "} else {\n";
print "    $('#badge-tab').html(i);\n";
print "    $('#badge-tab').show();\n";
print "}";
// on cache les autres box
print 'for(j=i+1 ; j <= 4 ; j++) {'."\n";
// on cache les éléments sans user
print "    $('#box-user-'+j).hide();\n";
print "}\n";

// la box d'ajout toujour en nosuer
print "$('#info-box-content-0').css('background-color', '#".$conf->global->MYSCHEDULE_colornouser."');\n";
print "$('#box-user-0').find('#box-icon-0').css('color', '#".$conf->global->MYSCHEDULE_colornouser."');\n";

print "nbContact=0;\n";
print "contactArray = iee.contactArray\n";
print "$('#contactlist').val('')\n";	
print "$('#contacttable tbody').empty();\n";
print "if (contactArray != null) {\n";
print "    $.each(contactArray, function(id, objContact) {\n";
print "        nbContact=nbContact+1;\n";
print "        $('#contactlist').val($('#contactlist').val()+id+',')\n";	
print "        var newLine = '<tr data-rowname=\"'+id+'\"><td>' + objContact.name + '</td><td>' + objContact.socname + '</td>';\n";
print "        newLine = newLine +'<td align=right>".img_picto('', 'delete', 'class="supprLineContact"' )."</td></tr>';\n";
print "        $('#contacttable tbody').append(newLine);\n";
print "    });\n";
print "};\n";

// on met à jour le badge
print "if (nbContact == 0) {\n";
print "    $('#badge-tab-contact').hide();\n";
print "} else {\n";
print "    $('#badge-tab-contact').html(nbContact);\n";
print "    $('#badge-tab-contact').show();\n";
print "}";

print "}\n";

print '});';

print "},\n";

// mise en forme de l'élement (surcharge)
print " eventDidMount: function (info) {\n";
// on ajoute la durée en bout de ligne
print "info.el.querySelector('div.fc-event-time').setAttribute('style','display:none;'); \n";

print "if (info.view.type == 'timeGridWeek') {\n";
print "	info.el.querySelector('.fc-event-main').title = info.event.extendedProps.description;\n";
print "} else {\n";
// on cache les infos qui ne servent à rien
print "	info.el.querySelector('div.fc-daygrid-event-dot').setAttribute('style','display:none;'); \n";
print "	var curElem = info.el.querySelectorAll('div.fc-event-title');\n";
// on affecte la couleur à l'élément
print "	curElem[0].setAttribute('style', 'background-color:'+info.event.backgroundColor);\n";
print "}";
// on met en forme l'élément au format html
print "info.el.querySelector('.fc-event-title').innerHTML = info.event.extendedProps.htmltitle;\n";

print "},\n";

print " events: {\n";
print "url: '".dol_buildpath("/myschedule/fichinter/ajax/",1);
print "events-feed.php?datedeb=".$fullcalendarfirstday;
print "&datefin=".$fullcalendarlastday;
print "&filterbystatut=".implode(",", $statutinter);
print "&choiceperiod=".$choiceperiod;
print "&dolstatut=".$dolstatut;
print "&periodsoc=".$periodsoc;
print "&periodcontact=".$periodcontact;
print "&perioduser=".$perioduser."',\n";
print "type: 'POST', // Send post data\n";
print "error: function() {\n";
print "alert('There was an error while fetching events.');\n";
print "}},\n";
print "visibleRange: {\n";
print "    start: '".$fullcalendarfirstday."',\n";
print "    end: '".$fullcalendarlastday."'\n";
print "  },\n";
print "});"."\n";

print "calendar.render();"."\n";
// pour avoir l'agenda en blanc
print '$(".fc-daygrid").css("background", "white");';
print '$(".fc-timegrid").css("background", "white");';
// pour colorer quelques boutons
print '$(".fc-delButton-button").css("color", "red").css("font-weight", "bold");';
print '$(".fc-changeUserButton-button").css("color", "#'.$conf->global->MYSCHEDULE_colornouser.'").css("font-weight", "bold");';
print '$(".fc-plannedButton-button").css("color", "#'.$conf->global->MYSCHEDULE_colornotplanned.'").css("font-weight", "bold");';
print '$(".fc-jobMadeButton-button").css("color", "#'.$conf->global->MYSCHEDULE_colornotmade.'").css("font-weight", "bold");';

print "$('#contacttable').on('click', '.supprLineContact', function() {\n";
print "    line_id = $(this).parents('tr').data('rowname');\n";
print "    $('#contactlist').val($('#contactlist').val().replace(line_id+',', ''));\n";
print "    $(this).parents('tr').remove();\n";
print "});\n";

print "});"."\n";


print "</script>";

// dialog de la création d'inter
// -------------------------------
print '<div id="dialog-addfichinter" style="padding:0;" class="hideobject" title="'.$langs->trans('AddFichInter').'">'."\n";
print '<form id="addfichinter" name="addfichinter" action="' . $_SERVER["PHP_SELF"] . '" method="post">';
print '<input type="hidden" name="token" value="' . $_SESSION ['newtoken'] . '">';
print '<input type="hidden" name="action" value="addFichInter">';
print '<input type="hidden" name="choiceperiod" value="'.$choiceperiod.'">';
print '<input type="hidden" name="firstdayweek" value="'.$firstdayweek.'">';
print '<input type="hidden" name="statutinter" value="'.$statutinter.'">';
print '<input type="hidden" name="periodweek" value="'.$periodweek.'">';
print '<input type="hidden" name="perioduser" value="'.$perioduser.'">';
print '<input type="hidden" name="periodsoc" value="'.$periodsoc.'">';
print '<input type="hidden" name="periodcontact" value="'.$periodcontact.'">';
print '<input type="hidden" name="dolstatut" value="'.$dolstatut.'">';

// on crée les onglets pour plus de lisibilité
print '<div id="tabsdialogadd">';
$tbltabs = array (
	0 => $langs->trans("General"),
	1 => $langs->trans("TimeAndUser"),
	2 => $langs->trans("Notes")
);

 print '<ul>';
foreach ($tbltabs as $key=>$value) {
	print '<li><a href="#tabsfc-'.$key.'">'.$value.'</a></li>';
}
print '</ul>';
print '<div id="tabsfc-0" style="min-height:250px">';

print '<table class="noborder" style="width:100%" >';
print "<tr><td class='fieldrequired' width=20%>".$langs->trans("ThirdParty")."</td><td>";

print $form->select_company($periodsoc, 'periodsoc_add', '', $showempty, 0, 0, array(), 0, 'minwidth400');
print "</td></tr>";
if ($conf->contrat->enabled) {
	$langs->load("contracts");
	print '<tr><td>'.$langs->trans("Contract").'</td><td>';
	$numcontrat = $formcontract->select_contract($periodsoc, "", 'contratid-add', 0, 1);
	print '</td></tr>';
}
if ($conf->projet->enabled) {
	$langs->load("projets");
	print '<tr><td>'.$langs->trans("Project").'</td><td>';
	// on sélectionne tous les contrats
	$numcontrat = $formprojet->select_projects($periodsoc, "", 'projetid_add');
	print '</td></tr>';
}

print "<tr><td>".$langs->trans("Status")."</td><td>";
print $langs->trans('Draft');
print "</td></tr>";

print "<tr><td valign=top>".$langs->trans("Description")."</td><td>";
print '<textarea name=description-add cols=65 rows=4></textarea></td></tr>';

// contacts a ajouter à l'inter
$showFonction=0;
$showSoc=1;
$showEmpty=1;
$multiple=true;
print '<tr><td>'.$langs->trans("Contacts")."</td>"; 
print "<td>";
print $form->selectcontacts(0, "", 'add_add_contact', $showEmpty, '', '', $showFonction, '', false, $showSoc
, 0, array(), 'style="width: 95%"', '', $multiple
);
print "</td></tr>";

print "</table>";
print '</div>';

print '<div id="tabsfc-1" style="min-height:250px">';
print '<table class="noborder" style="width:100%" >';
print '<tr class="liste_titre">';
//print '<td width=100px>'.$langs->trans('AffectedUser').'</td>';
print '<th width=400px><b>'.$langs->trans('Description').'</b></th>';
print '<td width=100px>'.$langs->trans('DateStart').'</td>';
print '<td width=100px>'.$langs->trans('Duration').'</td>';
print '</tr>';

for ($i=1;$i<=$conf->global->MYSCHEDULE_nbnewlineinter;$i++){
	print "<tr>";
	print "<td rowspan=2 valign=top>";
	print '<textarea id="np_desc-add-'.$i.'" name="np_desc-add-'.$i.'" cols=50 rows=3></textarea>';
	print "<script>
	ClassicEditor.create( document.querySelector( '#np_desc-add-".$i."' ),{ 
		removePlugins: [ 'Link', 'ImageUpload', 'MediaEmbed' ]
	} );
	</script>";
	print "</td>";
	print '<td valign=top>';
	// la date est actualisé à l'ouverture du popin en JS
	// par défaut elle est sur l'heure de début de la journée
	print $form->selectDate('', 'dateo-add-'.$i, 1, 1, 0, "");
	print '</td>';
	print '<td align=left valign=top>';
	$selectmode = 'select';
	if (!empty($conf->global->INTERVENTION_ADDLINE_FREEDUREATION))
		$selectmode = 'text';
	$form->select_duration('duration-add-'.$i, 3600, 0, $selectmode, 1);
	print '</td>';
	print '</tr>';
	print '<tr><td valign=top colspan=2>';
	$userSelect = ""; // on sélectionne l'user que pour la première ligne
	if($i==1) $userSelect = $perioduser?$perioduser:$user->id;
	print $form->select_dolusers($userSelect, 'userid-add-'.$i, 1, null, 0, null, null, 0, 56);
	print '<br><input type="checkbox" name="userid-chk-'.$i.'">';
	print $langs->trans("PlanifyUserToLine");
	print '</td></tr>';

}
print '</table>';
print '</div>';


print '<div id="tabsfc-2" style="min-height:250px">';
print '<table class="noborder" style="width:100%" >';
print "<tr><td valign=top>".$langs->trans("NotePublic")."</td><td>";
print '<textarea id=note_public-add name=note_public-add cols=70 rows=6></textarea></td></tr>';
print "<tr><td valign=top>".$langs->trans("NotePrivate")."</td><td>";
print '<textarea id=note_private-add name=note_private-add cols=70 rows=6></textarea></td></tr>';
print "</table>";
print "<script>
ClassicEditor.create( document.querySelector( '#note_public-add' ), { removePlugins: [ 'Link', 'ImageUpload', 'MediaEmbed' ] } );
ClassicEditor.create( document.querySelector( '#note_private-add' ), { removePlugins: [ 'Link', 'ImageUpload', 'MediaEmbed' ] } );
</script>";

print '</div>';
print '</div>';
print '</form>';
print '</div>'."\n";


// dialog de la modif d'inter
// ------------------------
print '<div id="dialog-editfichinter" style="padding:0;" class="hideobject" title="'.$langs->trans('EditFichInter').'">'."\n";

print '<form id="editfichinter" name="editfichinter" action="' . $_SERVER["PHP_SELF"] . '" method="post">';
print '<input type="hidden" name="token" value="' . $_SESSION ['newtoken'] . '">';
print '<input type="hidden" id="actionedit" name="action" value="editfichinter">';
// récupération des informations de l'interface
print '<input type="hidden" name="choiceperiod" value="'.$choiceperiod.'">';
print '<input type="hidden" name="periodweek" value="'.$periodweek.'">';
print '<input type="hidden" name="firstdayweek" value="'.$firstdayweek.'">';
print '<input type="hidden" name="statutinter" value="'.$statutinter.'">';
print '<input type="hidden" name="perioduser" value="'.$perioduser.'">';
print '<input type="hidden" name="periodsoc" value="'.$periodsoc.'">';
print '<input type="hidden" name="periodcontact" value="'.$periodcontact.'">';
print '<input type="hidden" name="dolstatut" value="'.$dolstatut.'">';

// les données sont mise à jour lors du click
print '<input type="hidden" id="fk_fichinterdet" name="fk_fichinterdet" value="">';
print '<input type="hidden" id="fk_fichinter" name="fk_fichinter" value="">';

// on crée les onglets pour plus de lisibilité
print '<div id="tabsdialogfc">';
$tbltabs = array (
	0 => $langs->trans("General"),
	1 => $langs->trans("TimeAndUser"),
	2 => $langs->trans("Contact"),
	3 => $langs->trans("Notes")
);

 print '<ul>';
foreach ($tbltabs as $key=>$value) {
	print '<li><a href="#tabsfc-'.$key.'">'.$value;
	if ($key == 1)
		print '&nbsp;<span id="badge-tab" class="badge" style="background-color:#C0C0C0">0</span>';
	if ($key == 2)
		print '&nbsp;<span id="badge-tab-contact" class="badge" style="background-color:#C0C0C0">0</span>';
		if ($key == 3)
		print '&nbsp;<span id="badge-tab-note" class="badge" style="background-color:#C0C0C0">0</span>';

	print '</a></li>';
}
print '</ul>';
print '<div id="tabsfc-0" style="min-height:250px">';
//print '';
print '<table class="noborder" style="width:100%" >';
print "<tr><td class='fieldrequired' width=20%>".$langs->trans("ThirdParty")."</td><td>";
print $form->select_company("", 'fk_soc_edit', '', $showempty, 0, 0, array(), 0, 'minwidth400');

print "</td></tr>";
// ca risque d'etre chaud
if ($conf->contrat->enabled) {
	$langs->load("Contracts");
	print '<tr><td>'.$langs->trans("Contract").'</td><td>';
	// on sélectionne tous les contrats
	$numcontrat = $formcontract->select_contract(-1, "", 'fk_contrat_edit', 0, 1);
	print '</td></tr>';
}
if ($conf->projet->enabled) {
	$langs->load("projets");
	print '<tr><td>'.$langs->trans("Project").'</td><td>';
	// on sélectionne tous les contrats
	$numcontrat = $formprojet->select_projects(-1, "", 'fk_projet_edit');
	print '</td></tr>';
}
print "<tr><td>".$langs->trans("Status")."</td><td>";
$statutArray = array(
	'0'=>$langs->trans('Draft'), 
	'1'=>$langs->trans('Validate'),
	'2'=>$langs->trans('StatusInterInvoiced'),
	'3'=>$langs->trans('Closed')
);
print $form->selectarray('fk_statut_edit', $statutArray, "", 0 );
print "</td></tr>";

print "<tr><td valign=top>".$langs->trans("Description")."</td><td>";
print '<textarea id=description_edit name=description_edit cols=65 rows=4></textarea></td></tr>';
print '</table>';
print '</div>';

print '<div id="tabsfc-1" style="min-height:250px">';
print '<table class="noborder" >';
print "<tr>";
print "<td rowspan=2 valign=top>";
print '<textarea name="np_desc_edit" id="np_desc_edit" cols=57 rows=4></textarea>';
print "<script>
ClassicEditor
	.create( document.querySelector( '#np_desc_edit' ), { removePlugins: ['Link', 'ImageUpload', 'MediaEmbed' ] } )
	.then( editor => { window.np_desc_edit = editor; } )
;
</script>";

print "</td>";
print '<td >'.$langs->trans('DateStart').'</td>';
print '<td valign=top>';
//la date est actualisé à l'ouverture du popin en JS
print $form->selectDate('', 'dateo-edit', 1, 1, 0, "");
print '</td>';
print '</tr>';
print '<tr><td>'.$langs->trans('Duration').'</td>';

$selectmode = 'select';
if (!empty($conf->global->INTERVENTION_ADDLINE_FREEDUREATION))
	$selectmode = 'text';

print '<td align=left valign=top>';
$form->select_duration('duration-edit', 3600, 0, $selectmode, 0);
print '</td>';
print '</tr>';
print '</table>';
// ensuite les utilisateurs
print '<div class="box-flex-container">';
// on stock dans une hidden la user présent
print '<input type=hidden name=userlist id=userlist>';

for ($i=1;$i<=4;$i++) {
	print '<div class="box-flex-item info-box-module" id="box-user-'.$i.'">';
	print '<div class="info-box info-box-sm info-box-module" ><div class="info-box-icon" >';
	print '<span id="box-icon-'.$i.'" class="fas fa-user inline-block valignmiddle"></span>';
	print '<span class="info-box-icon-version" style="text-align:left;color:red" >';
	print "<input type=checkbox name='chkDelUser-".$i."' value=1> ".$langs->trans('DelUser');
	print '</span>';
	print '</div>';
	print '<div id="info-box-content-'.$i.'" class="info-box-content info-box-text-module">';
	print '<span class="info-box-title" id="username-'.$i.'">USER</span>';
	print '<table class="noborder" >';
	print '<tr><td style="padding:3px">'.$langs->trans('Planned').'</td>';
	print '<td style="padding:3px" align=center>';
	$form->select_duration('planned-'.$i, 3600, 0, $selectmode, 0);
	print '</td></tr>';
	print '<tr><td style="padding:3px">'.$langs->trans('TimeMade').'</td>';
	print '<td style="padding:3px" align=center>';
	$form->select_duration('made-'.$i, 3600, 0, $selectmode, 0);
	print '</td></tr>';
	print "</table>";
	print '</div>'; 
	print '</div></div>';
}
// box d'ajout
print '<div class="box-flex-item info-box-module" id="box-user-0">';
print '<div class="info-box info-box-sm info-box-module" style="height:120px">';
print '<div class="info-box-icon" style="height:120px">';
print '<span id="box-icon-0" class="fas fa-user inline-block valignmiddle" ></span>';
print '</div>';
print '<div  id="info-box-content-0" style="height:110px" class="info-box-content info-box-text-module">';
print '<span class="info-box-title" id="username-'.$i.'">'.$langs->trans('NewUser').'</span>';

// ici le un nouvel utilisateur si besoin 
$filteruser="";
if ($user->admin == 0 && $user->rights->myschedule->alluser == 0)
	$filteruser=" AND (u.rowid = ".$user->id." OR fk_user=".$user->id.")";

	print $form->select_dolusers(
			"", 'newuser-0', $showempty,
			'', 0, '', '', 0, 0, 0, $filteruser
);
print '<table class="noborder" >';
print '<tr><td style="padding:1px">'.$langs->trans('Planned').'</td>';
print '<td style="padding:1px" align=center>';
$form->select_duration('planned-0', 0, 0, $selectmode, 0);
print '</td></tr>';
print '<tr><td style="padding:1px">'.$langs->trans('TimeMade').'</td>';
print '<td style="padding:1px" align=center>';
$form->select_duration('made-0', 0, 0, $selectmode, 0);
print '</td></tr>';
print "</table>";
print '</div>'; 
print '</div></div>';

print '</div>'; // flex-container

print '</div>'; 

print '<div id="tabsfc-2" style="min-height:250px">';
// champs visible durant les test
print '<input type=hidden name=contactlist id=contactlist>';

$showFonction=0;
$showSoc=1;
$showEmpty=1;
$multiple=true;
print '<table style="width:100%" >';
print '<tr><td width=130px>';
print $langs->trans("ContactsToAdd")."</td>"; 
print "<td width=600px>";
print $form->selectcontacts(0, "", 'add_edit_contact', $showEmpty, '', '', 
	$showFonction, '', false, $showSoc
	, 0, array(), 'style="width: 95%"', '', $multiple
);
print "</td></tr></table>";

// gestion des contacts déjà présent
print '<table id="contacttable" class="noborder" style="width:100%" >';
print '<thead><tr class="liste_titre">';
print '<th align=left >'.$langs->trans("ContactName").'</th>';
print '<th align=left >'.$langs->trans("SocName").'</th>';
print '<th align=right>'.$langs->trans("Suppr").'</th>';
print "</tr><thead>\n";
// les lignes sont ajouté en jquery
print "<tbody></tbody>\n";
print "</table>";

print '</div>';

print '<div id="tabsfc-3" style="min-height:250px">';
print '<table class="noborder" style="width:100%" >';
print "<tr><td valign=top>".$langs->trans("NotePublic")."</td><td>";
print "<textarea id='note_public_edit' name='note_public_edit' cols=60 rows=6></textarea>";
print "<tr><td valign=top>".$langs->trans("NotePrivate")."</td><td>";
print "<textarea id='note_private_edit' name='note_private_edit' cols=60 rows=6></textarea>";
// la mise en place des éditeurs wysiwyg
print "<script>
ClassicEditor
	.create( document.querySelector( '#note_public_edit'), { removePlugins: [ 'Link', 'ImageUpload', 'MediaEmbed' ]})
	.then( editor => { window.note_public_edit = editor; } )
;
ClassicEditor
	.create( document.querySelector( '#note_private_edit'), { removePlugins: ['Link', 'ImageUpload', 'MediaEmbed' ]})
	.then( editor => { window.note_private_edit = editor; } )
;
</script>";
print "</table>";
print '</div>';
print '</div>';
print '</div>';
print '</form>';
print '</div>'."\n";
// End of page
llxFooter();
$db->close();