<?php
/* Copyright (C) 2013-2021	Charlene BENKE	<charlie@patas-monkey.com>
*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file	   	htdocs/myschedule/tabs/massdelete.php
 *	\ingroup		myschedule
 *	\brief	  	Page of fichinter myschedule
 */

$res=0;
if (! $res && file_exists("../../main.inc.php")) 
	$res=@include("../../main.inc.php");		// For root directory
if (! $res && file_exists("../../../main.inc.php")) 
	$res=@include("../../../main.inc.php");	// For "custom" directory

require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/fichinter/class/fichinter.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';

if ($conf->projet->enabled)
	require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';

if ($conf->contrat->enabled)
	require_once DOL_DOCUMENT_ROOT.'/contrat/class/contrat.class.php';

//require_once DOL_DOCUMENT_ROOT."/holiday/class/holiday.class.php";

dol_include_once('/myschedule/core/lib/myschedule.lib.php');
dol_include_once('/myschedule/class/myschedule.class.php');

$langs->load('companies');
$langs->load('interventions');
$langs->load('bills');
$langs->load('myschedule@myschedule');


$action= GETPOST('action', 'alpha');

$choiceperiod= GETPOST('choiceperiod', 'alpha');
$ListInterdetId = GETPOST("listinterdetid", "alpha");

$ListInterId = GETPOST("listinterid", "alpha");

$periodyear=GETPOST('periodyear', 'int');
$periodyearmonth=GETPOST('periodyearmonth', 'int');
$periodmonth=GETPOST('periodmonth', 'int');
$periodweek=GETPOST('periodweek', 'int');

$periodyear_old=GETPOST('periodyear_old', 'int');
$periodyearmonth_old=GETPOST('periodyearmonth_old', 'int');
$periodmonth_old=GETPOST('periodmonth_old', 'int');
$periodweek_old=GETPOST('periodweek_old', 'int');

// Security check
if (! empty($user->societe_id))
	$socid=$user->societe_id;
$result = restrictedArea($user, 'ficheinter', $id, 'fichinter');



$form = new Form($db);
if ($conf->projet->enabled)
	$projet_static = new Project($db);
if ($conf->contrat->enabled)
	$contrat_static = new Contrat($db);

$fichinter_old = new Fichinter($db);
$fichinter_new = new Fichinter($db);
$fichinterdet_schedule_static = new fichinterdet_schedule($db);

$now=dol_now();

// on lance le clonage
if ($action=="clone") {

	$fichinter_new_line = new FichinterLigne($db);
	$arrayInter = explode(",", substr($ListInterId, 0, -1));
	foreach( $arrayInter as $fichinter_id) {
		$result= $fichinter_old->fetch($fichinter_id);
		$fichinter_new_Id = $fichinter_old->createFromClone($user);
		// on boucle ensuite sur les lignes nouvellement crée pour mettre à jour la date
		foreach( $fichinter_old->lines as $line) {

			// cherche la ligné que l'on a crée à partir des datas de la première
			$sql = "SELECT rowid FROM ".MAIN_DB_PREFIX."fichinterdet";
			$sql.= " WHERE fk_fichinter = ".$fichinter_new_Id;
			$sql.= " AND description = '".$db->escape($line->desc)."'";
			$sql.= " AND date = '".$db->idate($line->datei)."'";
			$sql.= " AND duree = ".$line->duration;

			$resql = $db->query($sql);
			if ($resql) {
				$obj = $db->fetch_object($resql);
				$lineid = $obj->rowid;
				// on met à jour en fonction des données qui ont été modifié (au minimum la date d'intervention décalée)
				$datei = dol_mktime(
					GETPOST('dateo-add-'.$line->id.'hour', 'int'), 
					GETPOST('dateo-add-'.$line->id.'min', 'int'), 0, 
					GETPOST('dateo-add-'.$line->id.'month', 'int'), 
					GETPOST('dateo-add-'.$line->id.'day', 'int'), 
					GETPOST('dateo-add-'.$line->id.'year', 'int')
				);
	
				$duration = convertTime2Seconds(
					GETPOST('duration-add-'.$line->id.'hour', 'int'), 
					GETPOST('duration-add-'.$line->id.'min', 'int')
				);
				
				// on met à jours les données de celle-ci
				$sql = "UPDATE ".MAIN_DB_PREFIX."fichinterdet SET";
				//$sql .= " description='".$db->escape($this->desc)."'";
				$sql .= " date='".$db->idate($datei)."'";
				$sql .= ",duree=".$duration;
				$sql .= " WHERE rowid = ".$lineid;
				dol_syslog("FichinterLigne::update", LOG_DEBUG);
				$resql = $db->query($sql);

				// on met à jour l'inter à partir des lignes de détail saisie
				$fichinter_new_line->fetch($lineid);
				$result = $fichinter_new_line->update_total();
			}

		}
		// pour se positionner à nouveau sur l'ancienne inter
		$result= $fichinter_old->fetch($fichinter_id);
		$result= $fichinter_new->fetch($fichinter_new_Id);

		// on traite les utilisateurs associé à l'inter
		$arrayUserSchedule = $fichinter_old->liste_contact(-1, 'internal');

		foreach($arrayUserSchedule as $UserSchedule) {
			if (GETPOST("AddUser-".$fichinter_old->id."-".$UserSchedule['id'] == 1)) {
				// on ajoute l'user
				$result = $fichinter_new->add_contact($UserSchedule['id'], 121, 'internal');

				// on regarde si il y a du temps planifié de saisie
				$DurationPlanned = convertTime2Seconds(
					GETPOST('planned-'.$fichinter_old->id."-".$UserSchedule['id'].'hour', 'int'), 
					GETPOST('planned-'.$fichinter_old->id."-".$UserSchedule['id'].'min', 'int')
				);

				$fichinterdet_schedule_static->fk_user = $UserSchedule['id'];
				$fichinterdet_schedule_static->fk_fichinterdet = $lineid;
				$fichinterdet_schedule_static->duration_planned = $DurationPlanned;
				$fichinterdet_schedule_static->insert();
			}
		}

		// on traite les contact liée à l'inter
		$arrayUserSchedule = $fichinter_old->liste_contact(-1, 'external');
		foreach($arrayUserSchedule as $ContactSchedule) {
			if (GETPOST("AddUser-".$fichinter_old->id."-".$ContactSchedule['id'] == 1)) {
				// on ajoute le contact
				$result = $fichinter_new->add_contact($ContactSchedule['id'], 131, 'external');
			}
		}

	}

	// on redirige vers la période de destination clonnée
	$urlRedir = "fullcalendar.php?choiceperiod=".$choiceperiod;
	$urlRedir.= "&periodyear=".$periodyear;
	$urlRedir.= "&periodweek=".$periodweek;
	$urlRedir.= "&periodmonth=".$periodmonth;

	Header("Location: ".$urlRedir);
}

llxHeader('', "", "", '', 0, 0);

/*
 * Show object in view mode
 */
$title=$langs->trans("mySchedule")." - ".$langs->trans("MassCloneList");

print load_fiche_titre($title, "", 'myschedule@myschedule');

print '<form method="POST" name=massaction action="massclonelist.php">';

print '<input type="hidden" name="action" value="clone">';

// on conserve les données pour la validation
print '<input type="hidden" name="choiceperiod" value="'.$choiceperiod.'">';


print '<input type="hidden" name="periodyear" value="'.$periodyear.'">';
print '<input type="hidden" name="periodyearmonth" value="'.$periodyearmonth.'">';
print '<input type="hidden" name="periodweek" value="'.$periodweek.'">';
print '<input type="hidden" name="periodmonth" value="'.$periodmonth.'">';

print '<table class="noborder " >';
print '<tr><td valign=top width=25%><h2>';
print $langs->trans("OriginPeriodClone");
print '<br><br>';
print $langs->trans("DropPeriodClone");
print '</h2></td><td valign=top><h2>';

if( $choiceperiod == "week") {
	print $langs->trans("Week")." : ".$periodweek_old ." - ". $periodyear_old;
} else {
	print $langs->trans("Month")." : ".$periodmonth_old ." / ". $periodyearmonth_old;
}
print '<br><br>';
if( $choiceperiod == "week") {
	print $langs->trans("Week")." : ".$periodweek ." - ". $periodyear;
} else {
	print $langs->trans("Month")." : ".$periodmonth ." / ". $periodyearmonth;
}

// on décale la date en fonction de la période de décalage demandé
if( $choiceperiod == "week") {
	// on récupère le premier jour de chaque semaine
	$dateori = firstdayweek($periodweek_old, $periodyear_old);
	$datedest = firstdayweek($periodweek, $periodyear);
	$decalageDate = $datedest - $dateori;
	// 
} else {
	// on décale de n mois (calcul assez simple...)
	$deltamonth= $periodmonth_old - $periodmonth;
	$deltayear= $periodyearmonth_old - $periodyearmonth_old;
	$ecartMonth = ($deltayear * 12) + $deltamonth;
	$effectiveDate =  strtotime("+".$ecartMonth." months", $line->datei);
}


print '</h2></td><td align=right>';
print '<input type="submit" class="butAction"  id="cloneElement" value="'.$langs->trans("CloneElement").'">';
print '<br><br>';
print '<input type="button" class="butActionDelete" id="cancel" value="'.$langs->trans("Cancel").'">';
print '</td></tr>';
print "</table>";

// récup des lignes d'inter
$sql = 'SELECT distinct fk_fichinter';
$sql.= ' FROM '.MAIN_DB_PREFIX.'fichinterdet';
$sql.= ' WHERE rowid in ('.substr($ListInterdetId, 0, -1).')';
$sql.= ' ORDER BY date';
$ListInterId="";
$resql = $db->query($sql);
if ($resql) {
	$num = $db->num_rows($resql);
	$j = 0;
	
	$object = new Fichinter($db);
	$fichinterdet_schedule = new fichinterdet_schedule($db);
	$userstatic=new User($db);
	while ($j < $num) {
		$objp = $db->fetch_object($resql);
		$object->fetch($objp->fk_fichinter);
		$object->fetch_thirdparty();
		$ListInterId.=$objp->fk_fichinter.",";
		$morehtmlref='<div class="refidno">';
		$morehtmlref.=$langs->trans('ThirdParty') . ' : ' . $object->thirdparty->getNomUrl(1);
		$morehtmlref.='<br>';
		$morehtmlref.=$langs->trans('Desc') . ' : ' . $object->desc;
		$morehtmlref.='<br>';
		$morehtmlref.= dol_print_date($object->dateo, 'daytext') ;
		if ($object->dateo != $object->datee)
			$morehtmlref.= ' <b>- '. dol_print_date($object->datee, 'daytext') . '</b>' ;

		$morehtmlref.= " (".convertSecondToTime($object->duration, 'all', $conf->global->MAIN_DURATION_OF_WORKDAY).")";
		$morehtmlref.='</div>';

		// on ajoute la date et la durée
		dol_fiche_head( array(), '0', '' , -1, "myschedule@myschedule");
		dol_banner_tab($object, '', '', 0, '', '', $morehtmlref);
		print '<table class="noborder" style="width:100%" >';
		print '<tr class="liste_titre">';
		print '<td width=400px>'.$langs->trans('Description').'</td>';
		print '<td align=center>'.$langs->trans('DateStart').'</td>';
		print '<td align=center>'.$langs->trans('Duration').'</td>';
		$arrayUserSchedule = $object->liste_contact(-1, 'internal');
		foreach($arrayUserSchedule as $UserSchedule) {
			print '<td align=center>';
			print "<input type=checkbox name='AddUser-'".$object->id."-".$UserSchedule['id']."' checked value=1> ";
			print $UserSchedule['nom'];
			print '</td>';
		}
		print '</tr>';

		// on affiche les lignes de détail de l'inter
		foreach($object->lines as $line){
			//var_dump($line);
			print "<tr>";
			print "<td>";
			print $line->desc;
			print "</td>";
			print '<td align=center nowrap>';
			print $form->selectDate(($line->datei+$decalageDate), 'dateo-add-'.$line->id, 1, 1, 0, "");
			print '</td>';
			print '<td align=center nowrap>';
			$selectmode = 'select';
			if (!empty($conf->global->INTERVENTION_ADDLINE_FREEDUREATION))
				$selectmode = 'text';
			$form->select_duration('duration-add-'.$line->id, $line->duration, 0, $selectmode, 0);
			print '</td>';
			// on affiche ensuite les collaborateurs
			foreach($arrayUserSchedule as $UserSchedule) {
				print '<td align=center nowrap>';
				$fichinterdet_schedule->fetch(0, $UserSchedule['id'], $line->id);
				$form->select_duration(
						'planned-'.$line->id.'-'.$UserSchedule['id'], 
						$fichinterdet_schedule->duration_planned, 0,
						$selectmode, 0
				);
				print '</td>';
			}
			print '</tr>';
		}
		print '</table>';
		dol_fiche_end();

		$j++;
	}
}
print '<input type="hidden" name="listinterid" value="'.$ListInterId.'">';
print '</form>';
print '<script>';
print "$('div.tabBar').css({'padding-top':'10px','padding-left':'10px','padding-right':'10px'});\n";
print '</script>';

// End of page
llxFooter();
$db->close();