<?php
/* Copyright (C) 2013-2021	Charlene BENKE	<charlie@patas-monkey.com>
*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file	   	htdocs/myschedule/tabs/massuser.php
 *	\ingroup		myschedule
 *	\brief	  	Page of fichinter myschedule
 */

$res=0;
if (! $res && file_exists("../../main.inc.php")) 
	$res=@include("../../main.inc.php");		// For root directory
if (! $res && file_exists("../../../main.inc.php")) 
	$res=@include("../../../main.inc.php");	// For "custom" directory

require_once DOL_DOCUMENT_ROOT.'/core/class/html.form.class.php';
require_once DOL_DOCUMENT_ROOT.'/fichinter/class/fichinter.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';

if ($conf->projet->enabled)
	require_once DOL_DOCUMENT_ROOT.'/projet/class/project.class.php';

if ($conf->contrat->enabled)
	require_once DOL_DOCUMENT_ROOT.'/contrat/class/contrat.class.php';

//require_once DOL_DOCUMENT_ROOT."/holiday/class/holiday.class.php";

dol_include_once('/myschedule/core/lib/myschedule.lib.php');
dol_include_once('/myschedule/class/myschedule.class.php');

$langs->load('companies');
$langs->load('interventions');
$langs->load('bills');
$langs->load('myschedule@myschedule');

$error=0;

$id 	= GETPOST('id', 'int');
$ref 	= GETPOST('ref', 'alpha');
$action	= GETPOST('action', 'alpha');

// si non renseigné on prend le paramétre par défaut TODO, à valider
$choiceperiod= GETPOST('choiceperiod')?GETPOST('choiceperiod', 'alpha'):'week';
$firstdayweek= GETPOST('firstdayweek')?strtotime( GETPOST('firstdayweek', 'alpha')):"";


$perioduser=GETPOST('perioduser', 'int');
if (!$perioduser && $user->admin == 0  && $user->rights->myschedule->alluser == 0)
	$perioduser=$user->id;

$periodsoc=GETPOST('periodsoc', 'int');
if ($periodsoc ==0 && ! empty($user->societe_id))
	$periodsoc = $user->societe_id;


$dolstatut=GETPOST('dolstatut')?GETPOST('dolstatut', 'int'):-1;

$filterbystatut = explode(",", GETPOST('filterbystatut',"text") !=""?GETPOST('filterbystatut', 'text'):"nouser,notmade,notplanned,made");

$periodyear=GETPOST('periodyear', 'int');
if (!$periodyear)
	$periodyear=date('Y');

$periodyearmonth=GETPOST('periodyearmonth', 'int');
if (!$periodyearmonth)
	$periodyearmonth=date('Y');

$periodmonth=GETPOST('periodmonth', 'int');
if (! $periodmonth )
	$periodmonth=date('m');

$periodweek=GETPOST('periodweek', 'int');
if (!$periodweek)
	$periodweek=date('W');

if ($choiceperiod == 'week') {
	if ($firstdayweek == "") 
		$firstdayweek = firstdayweek($periodweek, $periodyear);
	else
		$periodweek = date("W", $firstdayweek);

	$periodmonth=date('m', $firstdayweek);
	$lastdayweek = strtotime(date("Y-m-d", strtotime(date('d-m-Y', $firstdayweek)))." +6 day"); 

	$fullcalendarfirstday=date("Y-m-d", $firstdayweek);
	$fullcalendarlastday=date("Y-m-d", $lastdayweek);	
} 
if ($choiceperiod=='month') {
	$fullcalendarfirstday=date("Y-m-d", dol_mktime(0, 0, 0, $periodmonth, 1, $periodyearmonth));
	$fullcalendarlastday=date("Y-m-d", dol_mktime(0, 0, 0, $periodmonth, 30, $periodyearmonth));
} 

// Security check
if (! empty($user->societe_id))
	$socid=$user->societe_id;
$result = restrictedArea($user, 'ficheinter', $id, 'fichinter');

/*
 * View
 */
$arrayofcss = array
	( '/myschedule/js/main.min.css'
);

$arrayofjs = array
	( '/myschedule/js/main.min.js'
	, '/myschedule/js/moment.min.js'
	, '/myschedule/js/locales/fr.js'
);
$title=$langs->trans("mySchedule")." - ".$langs->trans("MassUserAffectation");
$help_url="https://wiki.patas-monkey.com/index.php?title=MySchedule#Affectation_des_utilisateurs";

llxHeader('', $title, $help_url, '', 0, 0, $arrayofjs, $arrayofcss, '');


$form = new Form($db);
if ($conf->projet->enabled)
	$projet_static = new Project($db);
if ($conf->contrat->enabled)
	$contrat_static = new Contrat($db);

$now=dol_now();

/*
 * Show object in view mode
 */

print load_fiche_titre($title, "", 'myschedule@myschedule');

print '<form method="POST" name=massaction >';

print '<table class="noborder" >';
print '<tr><td valign=bottom width=25%><h2>';
// ici la période actuelle
if( $choiceperiod == "week") {
	print $langs->trans("Week")." : ".$periodweek ." - ". $periodyear;
} else {
	print $langs->trans("Month")." : ".$periodmonth ." / ". $periodyearmonth;
}
print '</h2><br>';
print $langs->trans("Users");
print '</td><td valign=bottom>';
$filteruser="";
if ($user->admin == 0 && $user->rights->myschedule->alluser == 0)
	$filteruser=" AND (u.rowid = ".$user->id." OR fk_user=".$user->id.")";
print $form->select_dolusers(
			$perioduser, 'perioduser', $showempty,
			'', 0, '', '', 0, 0, 0, $filteruser
);
print '</td><td align=right>';
print '<input type="button" class="butAction" id="affectUser" value="'.$langs->trans("AffectUser").'">';
print '<input type="button" class="butAction" id="affectUserAndTime" value="'.$langs->trans("AffectUserAndTime").'">';
print '<br><br><input type="button" class="butActionDelete"  id="unaffectUser" value="'.$langs->trans("UnAffectUser").'">';
print '<input type="button" class="butActionDelete" id="cancel" value="'.$langs->trans("Cancel").'">';
print '</td></tr>';
print "</table>";

if( $choiceperiod == "month") {
	print $langs->trans("InfoForSelectAllDay");
	print "<br>";
	print $langs->trans("InfoForSelectAllMonth");
} else
	print $langs->trans("InfoForSelectAllDay");

print "<div id='calendar' ></div>";

print '</form>';
//print '<br>';
print "<script>";
print "document.addEventListener('DOMContentLoaded', function() {"."\n";
print "var calendarEl = document.getElementById('calendar');"."\n";
print "var calendar = new FullCalendar.Calendar(calendarEl, {"."\n";

print "locale: 'fr',\n";
if ($choiceperiod == 'week')
	print "dayHeaderFormat: {weekday: 'long', day: '2-digit', month : '2-digit'},\n";
else
	print "dayHeaderFormat: {weekday: 'long'},\n";
print "timeZone: 'UTC',\n";
print "editable: false,\n";
print "themeSystem: 'standard',\n";
print "droppable: false,\n";
print "fixedWeekCount: false,\n";

$startHourDay=convertSecondToTime($conf->global->MYSCHEDULE_startHourDay?$conf->global->MYSCHEDULE_startHourDay:2*3600, "allhourmin", 86400);
$endHourDay=convertSecondToTime($conf->global->MYSCHEDULE_endHourDay?$conf->global->MYSCHEDULE_endHourDay:23*3600, "allhourmin", 86400);
$startHourWork=convertSecondToTime($conf->global->MYSCHEDULE_startHourWork?$conf->global->MYSCHEDULE_startHourWork:9*3600, "allhourmin", 86400);
$endHourWork=convertSecondToTime($conf->global->MYSCHEDULE_endHourWork?$conf->global->MYSCHEDULE_endHourWork:20*3600, "allhourmin", 86400);
print "slotMinTime: '".$startHourDay."',\n";
print "scrollTime: '".$startHourWork."',\n";
print "slotMaxTime: '".$endHourDay."',\n";
print "businessHours: {\n";
print "	daysOfWeek: [ 1, 2, 3, 4, 5 ],\n"; // Monday - Thursday
print "startTime: '".$startHourWork."',\n"; // a start time (10am in this example)
print "endTime: '".$endHourWork."',\n"; // an end time (6pm in this example)
print "},\n";

print "headerToolbar: {\n";
print "start: '',\n";
print "end: ''\n";
print "  },\n";

//print "start: 'title',\n";
//print "end: 'cancelButton submitButton'\n";

print "initialDate: '".$fullcalendarfirstday."',\n";
// selection du mode d'affichage de full calendar
switch($choiceperiod) {
	case "week":
		print "initialView: 'timeGridWeek',\n";
		print "allDaySlot: false,\n";
		break;
	case "month":
		print "initialView: 'dayGridMonth',"."\n";
		print "weekNumbers: true,\n";
		break;
}


// on charge la selection en masse 
include 'navlinks.inc.php'; // Must be include, not include_once

// on charge la liste des évènements
include 'events-load.inc.php'; // Must be include, not include_once

print "visibleRange: {\n";
print "    start: '".$fullcalendarfirstday."',\n";
print "    end: '".$fullcalendarlastday."'\n";
print "  },\n";
print "});"."\n";

print "calendar.render();"."\n";
// pour avoir l'agenda en blanc
print '$(".fc-daygrid").css("background", "white");';
print '$(".fc-timegrid").css("background", "white");';


/// Gestion des boutons, doit être faite ici pour acéder aux évents
print "$('#unaffectUser').click( function() {\n"; 	// lancement de la suppression des évents
	print "calendar.getEvents().forEach(function(item){\n";
	print "    selectuser = $('#perioduser').val();\n";
	//         si l'évent a été sélectionné
	print "    if (item.extendedProps.selected) {\n";
	print "        $.ajax({ async: false, type: 'GET',";
	print "         url:'".dol_buildpath("/myschedule/fichinter/ajax/", 1);
	print "event-user.php?id='+item.id+'&fk_fichinter='+item.extendedProps.fk_fichinter";
	print "+'&userid='+selectuser+'&unaffect=1'});\n";
	print "    }\n";
	print "});\n";

	print "$('#cancel').trigger('click');\n";
print "});\n";

print "$('#affectUser').click( function() {\n"; 	// lancement de la suppression des évents
	print "calendar.getEvents().forEach(function(item){\n";
	print "    selectuser = $('#perioduser').val();\n";
	print "    duree=0;\n";
	//         si l'évent a été sélectionné
	print "    if (item.extendedProps.selected) {\n";
	print "        $.ajax({ async: false, type: 'GET',";
	print "        url:'".dol_buildpath("/myschedule/fichinter/ajax/", 1);
	print "event-user.php?id='+item.id+'&fk_fichinter='+item.extendedProps.fk_fichinter";
	print "+'&userid='+selectuser});\n";
	print "    }\n";
	print "});\n";
	// on retourne sur le fullcalendar après mise à jour
	print "$('#cancel').trigger('click');\n";
print "})\n";
	

print "$('#affectUserAndTime').click( function() {\n"; 	// lancement de la suppression des évents
	print "calendar.getEvents().forEach(function(item){\n";
	print "    selectuser = $('#perioduser').val();\n";
	print "    duree=item.extendedProps.duree;\n";
	//         si l'évent a été sélectionné
	print "    if (item.extendedProps.selected) {\n";
	print "        $.ajax({ async: false, type: 'GET',";
	print "        url: '".dol_buildpath("/myschedule/fichinter/ajax/", 1);
	print "event-user.php?id='+item.id+'&fk_fichinter='+item.extendedProps.fk_fichinter";
	print "+'&userid='+selectuser+'&duree='+duree});\n";
	print "    }\n";
	print "});\n";

	// on retourne sur le fullcalendar après mise à jour
	print "$('#cancel').trigger('click');\n";
print "})\n";

print "});"."\n";

// le cancel n'a pas besoin d'etre dans la déclaration du calendar
print "$('#cancel').click( function() {\n";
	print "window.open('".dol_buildpath("/myschedule/fichinter/", 1);
	print "fullcalendar.php?choiceperiod=".$choiceperiod;
	print "&periodyear=".$periodyear;
	print "&periodweek=".$periodweek;
	print "&periodmonth=".$periodmonth;
	print $urlPeriodFilter."', '_self');\n";
print "})\n";


print "</script>";
print '</div>'."\n";

// End of page
llxFooter();
$db->close();