<?php
/* Copyright (C) 2013-2020	Charlene BENKE	<charlie@patas-monkey.com>
*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file	   	htdocs/myschedule/ficinter/navlinks.inc.php
 *	\ingroup		myschedule
 *	\brief	  	Page of fichinter myschedule
 */

// sélection/déselection de l'évènement selon le click sur l'évent
print "eventClick: function(info) {\n";
	if( $choiceperiod == "week")
		print "var curElem = info.el.querySelectorAll('div.fc-event-main-frame');\n";	
	else 
		print "var curElem = info.el.querySelectorAll('div.fc-event-title');\n";	

	print 'if(info.event.extendedProps.selected == false) {'."\n";
	print "    var divelem = document.createElement('div');\n";
	print "    divelem.setAttribute('style', 'background-color:lightyellow');\n";	
	print "    divelem.innerHTML = '".img_picto("", "tick")."<B>".$langs->transnoentities('Selected')."</B>';\n";
	print "    curElem[0].insertBefore(divelem, curElem[0].childNodes[0]);\n";
	print "} else {\n";
	print "    curElem[0].childNodes[0].remove();\n";
	print "}\n";	

	print "info.event.setExtendedProp( 'selected', !info.event.extendedProps.selected )\n";
	print "},\n";	

 // mise en forme de l'élement (surcharge) au chargement des events
print "eventDidMount: function (info) {\n";
	print "info.el.querySelector('.fc-event-title').innerHTML = info.event.extendedProps.htmltitle;\n";
	print "info.el.querySelector('div.fc-event-time').setAttribute('style','display:none;'); \n";

	// on ajoute la durée en bout de ligne
	if( $choiceperiod == "week") {
		// on ajoute l'id de l'élement pour le récupérer plus tard
		print "info.el.querySelector('div.fc-event-main-frame').setAttribute('id', info.event.id);\n";
		print "info.el.querySelector('.fc-event-main').title = info.event.extendedProps.description;\n";
	} else {
		print "info.el.querySelector('div.fc-daygrid-event-dot').setAttribute('style','display:none;');\n";
		// on ajoute l'id de l'élement pour le récupérer plus tard
		print "info.el.querySelector('div.fc-daygrid-event-dot').setAttribute('id', info.event.id);\n";
		print "var curElem = info.el.querySelectorAll('div.fc-event-title');\n";
		print "curElem[0].setAttribute('style', 'background-color:'+info.event.backgroundColor);\n";
	}
print "},\n";
	

// on click sur le numéro de la semaine de la vue mois, 
// cela selectionne les élements du mois
print "navLinks: true,\n";
print " navLinkWeekClick: function(weekStart, jsEvent) {\n";
print " var dateOfWeek= new Date(weekStart);\n";

//     on boucle sur les jours de la semaine
print "for (i=0;i<7;i++) {\n";
//         on boucle sur les éléments
print "    calendar.getEvents().forEach(function(item){ \n";
print "        if (item.startStr.substring(0,10) == dateOfWeek.toISOString().substring(0,10)) {\n";
print "	           curElem = $('div#'+item.id+'.fc-daygrid-event-dot').parent();\n";
print "            if(item.extendedProps.selected == false) {\n";
print "                var divelem = document.createElement('div');\n";
print "                divelem.setAttribute('style', 'background-color:lightyellow');\n";	
print "                divelem.innerHTML = '".img_picto("", "tick")."<B>".$langs->transnoentities('Selected')."</B>';\n";		
print "                curElem[0].childNodes[2].insertBefore(divelem, curElem[0].childNodes[2].childNodes[0]);\n";
print "            } else {\n";
print "                curElem[0].childNodes[2].childNodes[0].remove();\n";
print "            }\n";	
//                 on selectionne l'élement, seulement en mode mois...
print "            item.setExtendedProp( 'selected', !item.extendedProps.selected );\n";
print "        }\n";
print "    })\n";
//             on passe au jour suivant
print "        dateOfWeek.setDate(dateOfWeek.getDate() + 1);\n";
print " }},\n";

print " navLinkDayClick: function(date, jsEvent) {\n";
print " var dateday = date.toISOString();\n";
print " calendar.getEvents().forEach(function(item){ \n";
print "    if (item.startStr.substring(0,10) == dateday.substring(0,10)) {\n";
//             on inverse la sélection
print "        item.setExtendedProp( 'selected', !item.extendedProps.selected )\n";
// on selectionne le div par son id
if( $choiceperiod == "week") {
	//             on sélectionne le rendu de l'évent par son id (ajouté dans le render...)
	print "	       curElem = $('div#'+item.id+'.fc-event-main-frame');\n";
	print "        if (item.extendedProps.selected) {\n";
	print "            var divelem = document.createElement('div');\n";
	print "            divelem.setAttribute('style', 'background-color:lightyellow');\n";	
	print "            divelem.innerHTML = '".img_picto("", "tick")."<B>".$langs->transnoentities('Selected')."</B>';\n";
	print "            curElem[0].insertBefore(divelem, curElem[0].childNodes[0]);\n";
	print "        } else {\n";
	print "            curElem[0].childNodes[0].remove();\n";
	print "        }\n";
} else {
	print "	       curElem = $('div#'+item.id+'.fc-daygrid-event-dot').parent();\n";
	print '        if(item.extendedProps.selected) {'."\n";
	print "            var divelem = document.createElement('div');\n";
	print "            divelem.setAttribute('style', 'background-color:lightyellow');\n";	
	print "            divelem.innerHTML = '".img_picto("", "tick")."<B>".$langs->transnoentities('Selected')."</B>';\n";		
	print "            curElem[0].childNodes[2].insertBefore(divelem, curElem[0].childNodes[2].childNodes[0]);\n";
	print "        } else {\n";
	print "            curElem[0].childNodes[2].childNodes[0].remove();\n";
	print "        }\n";
}
print "    }\n";
print "})},\n";