-- ===========================================================================
-- Copyright (C) 2003		Rodolphe Quiedeville <rodolphe@quiedeville.org>
-- Copyright (C) 2012-2014	Laurent Destailleur  <eldy@users.sourceforge.net>
-- Copyright (C) 2009		Regis Houssin        <regis.houssin@capnetworks.com>
-- Copyright (C) 2010		Juanjo Menent        <jmenent@2byte.es>
-- Copyright (C) 2017-2018	Charlie Benke		<charlie@patas-monkey.com>
-- 
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program. If not, see <http://www.gnu.org/licenses/>.
--
-- ===========================================================================

ALTER TABLE llx_user_dailytime ADD date_start datetime NULL DEFAULT NULL;
ALTER TABLE llx_user_dailytime ADD enabled integer;

create table llx_user_dailytime
(
	fk_user				integer,
	date_start			date DEFAULT NULL,				-- date de dbut d'activation
	enabled				integer, 						-- la priode est active
	monday_am			double NULL DEFAULT NULL,		-- lundi matin
	monday_pm			double NULL DEFAULT NULL,		-- lundi aprs-midi
	monday_closeday		integer NULL DEFAULT NULL,		-- lundi frie

	tuesday_am			double NULL DEFAULT NULL,		-- mardi matin
	tuesday_pm			double NULL DEFAULT NULL,		-- mardi aprs-midi
	tuesday_closeday	integer NULL DEFAULT NULL,		-- mardi frie

	wednesday_am		double NULL DEFAULT NULL,		-- mercredi matin
	wednesday_pm		double NULL DEFAULT NULL,		-- mercredi aprs-midi
	wednesday_closeday	integer NULL DEFAULT NULL,		-- mercredi frie

	thursday_am			double NULL DEFAULT NULL,		-- jeudi matin
	thursday_pm			double NULL DEFAULT NULL,		-- jeudi aprs-midi
	thursday_closeday	integer NULL DEFAULT NULL,		-- jeudi frie

	friday_am			double NULL DEFAULT NULL,		-- vendredi matin
	friday_pm			double NULL DEFAULT NULL,		-- vendredi aprs-midi
	friday_closeday		integer NULL DEFAULT NULL,		-- vendredi frie

	saturday_am			double NULL DEFAULT NULL,		-- samedi matin
	saturday_pm			double NULL DEFAULT NULL,		-- samedi aprs-midi
	saturday_closeday	integer NULL DEFAULT NULL,		-- samedi frie

	sunday_am			double NULL DEFAULT NULL,		-- dimanche matin
	sunday_pm			double NULL DEFAULT NULL,		-- dimanche aprs-midi
	sunday_closeday		integer NULL DEFAULT NULL,		-- dimanche frie
	entity				integer		DEFAULT 1 NOT NULL,	-- fuckin multi company id

	tms			TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP

)ENGINE=innodb;
