<?php
/* Copyright (C) 2002-2006	Rodolphe Quiedeville<rodolphe@quiedeville.org>
 * Copyright (C) 2002-2003	Jean-Louis Bergamo	<jlb@j1b.org>
 * Copyright (C) 2004-2012	Laurent Destailleur	<eldy@users.sourceforge.net>
 * Copyright (C) 2004		Eric Seigne			<eric.seigne@ryxeo.com>
 * Copyright (C) 2005-2012	Regis Houssin		<regis.houssin@capnetworks.com>
 * Copyright (C) 2005		Lionel Cousteix		<etm_ltd@tiscali.co.uk>
 * Copyright (C) 2011		Herve Prot			<herve.prot@symeos.com>
 * Copyright (C) 2012		Juanjo Menent		<jmenent@2byte.es>
 * Copyright (C) 2013		Florian Henry		<florian.henry@open-concept.pro>
 * Copyright (C) 2013-2014	Alexandre Spangaro	<alexandre.spangaro@gmail.com>
 * Copyright (C) 2014-2018	Charlene BENKE		<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	   \file	   /management/userdailytime.php
 *	   \brief	  Tab of user for dailytime input
 */

$res=@include("../main.inc.php");					// For root directory
if (! $res && file_exists($_SERVER['DOCUMENT_ROOT']."/main.inc.php"))
	$res=@include($_SERVER['DOCUMENT_ROOT']."/main.inc.php"); // Use on dev env only
if (! $res) $res=@include("../../main.inc.php");		// For "custom" directory


require_once DOL_DOCUMENT_ROOT.'/user/class/user.class.php';
require_once DOL_DOCUMENT_ROOT.'/user/class/usergroup.class.php';
require_once DOL_DOCUMENT_ROOT.'/contact/class/contact.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/images.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/extrafields.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';

dol_include_once('/myschedule/core/lib/myschedule.lib.php');
dol_include_once('/myschedule/class/dailytime.class.php');


$id			= GETPOST('id', 'int');
$action		= GETPOST('action', 'alpha');



// Security check
$socid=0;
if ($user->societe_id > 0) 
	$socid = $user->societe_id;

// Security check
if ($id == 0  &&(! $user->admin  )) 
	accessforbidden();
else
	$result = restrictedArea($user, 'user', $id, '&user', $feature2);

$langs->load("users");
$langs->load("companies");
$langs->load("myschedule@myschedule");


/**
 * Actions
 */

$daily = new Dailytime($db);
$daily->fetch($id);


if ($action != "") {
	$daily->fk_user = $id;
	$dateo=dol_mktime('23', '59', '59', $_POST["dateomonth"], $_POST["dateoday"], $_POST["dateoyear"]);
	$daily->date_start				= $dateo;

	$daily->monday_am			= GETPOST("monday_amhour")*3600 + GETPOST("monday_ammin")*60;
	$daily->monday_pm			= GETPOST("monday_pmhour")*3600 + GETPOST("monday_pmmin")*60;
	$daily->monday_closeday		= (GETPOST("monday_closeday")?GETPOST("monday_closeday"):"0");
	$daily->tuesday_am			= GETPOST("tuesday_amhour")*3600 + GETPOST("tuesday_ammin")*60;
	$daily->tuesday_pm			= GETPOST("tuesday_pmhour")*3600 + GETPOST("tuesday_pmmin")*60;
	$daily->tuesday_closeday	= (GETPOST("tuesday_closeday")?GETPOST("tuesday_closeday"):"0");
	$daily->wednesday_am		= GETPOST("wednesday_amhour")*3600 + GETPOST("wednesday_ammin")*60;
	$daily->wednesday_pm		= GETPOST("wednesday_pmhour")*3600 + GETPOST("wednesday_pmmin")*60;
	$daily->wednesday_closeday	= (GETPOST("wednesday_closeday")?GETPOST("wednesday_closeday"):"0");
	$daily->thursday_am			= GETPOST("thursday_amhour")*3600 + GETPOST("thursday_ammin")*60;
	$daily->thursday_pm			= GETPOST("thursday_pmhour")*3600 + GETPOST("thursday_pmmin")*60;
	$daily->thursday_closeday	= (GETPOST("thursday_closeday")?GETPOST("thursday_closeday"):"0");
	$daily->friday_am			= GETPOST("friday_amhour")*3600 + GETPOST("friday_ammin")*60;
	$daily->friday_pm			= GETPOST("friday_pmhour")*3600 + GETPOST("friday_pmmin")*60;
	$daily->friday_closeday		= (GETPOST("friday_closeday")?GETPOST("friday_closeday"):"0");
	$daily->saturday_am			= GETPOST("saturday_amhour")*3600 + GETPOST("saturday_ammin")*60;
	$daily->saturday_pm			= GETPOST("saturday_pmhour")*3600 + GETPOST("saturday_pmmin")*60;
	$daily->saturday_closeday	= (GETPOST("saturday_closeday")?GETPOST("saturday_closeday"):"0");
	$daily->sunday_am			= GETPOST("sunday_amhour")*3600 + GETPOST("sunday_ammin")*60;
	$daily->sunday_pm			= GETPOST("sunday_pmhour")*3600 + GETPOST("sunday_pmmin")*60;
	$daily->sunday_closeday		= (GETPOST("sunday_closeday")?GETPOST("sunday_closeday"):"0");
}

if ($action == 'update')
	$daily->update($id);
elseif ($action == 'insert')
	$daily->insert();

// sur l'onglet param�trage
if ($id != 0) {
	$object = new User($db);
	$object->fetch($id);
}


/*
 * View
 */

$form = new Form($db);
$formother=new FormOther($db);



/* ************************************************************************** */
/*																			*/
/* View and edition															*/
/*																			*/
/* ************************************************************************** */

if ($id == 0) {
	// show management seting tabs for default value
	$page_name = $langs->trans("myScheduleSetup") . " - " .$langs->trans("DefaultUserDaily");
	llxHeader('', $page_name);

	$linkback='<a href="'.DOL_URL_ROOT.'/admin/modules.php">'.$langs->trans("BackToModuleList").'</a>';
	print_fiche_titre($page_name, $linkback, 'title_setup');

	// Configuration header
	$head = myschedule_admin_prepare_head();
	dol_fiche_head($head, 'userdaily', $langs->trans("mySchedule"), 0, "myschedule@myschedule");

	print_titre($langs->trans("myScheduleDefaultUserDailySettingValue"));
	print '<br>';

	// on r�cup les hrs par d�faut

} else {

	llxHeader('', $langs->trans("UserCard"));

	// Show user tabs
	$head = user_prepare_head($object);

	$title = $langs->trans("User");
	dol_fiche_head($head, 'dailyschedule', $title, 0, 'user');

	/*
	* Fiche en mode visu
	*/

	$linkback = '';

	if ($user->rights->user->user->lire || $user->admin) {
		$linkback = '<a href="'.DOL_URL_ROOT.'/user/index.php">'.$langs->trans("BackToList").'</a>';
	}

	dol_banner_tab($object, 'id', $linkback, $user->rights->user->user->lire || $user->admin);
}

print '<div class="underbanner clearboth"></div>';

print "<form method='post' action='".$_SERVER['PHP_SELF']."'>";
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';
if ($id != $daily->fk_user)
	print '<input type="hidden" name="action" value="insert">';
else
	print '<input type="hidden" name="action" value="update">';

print '<input type="hidden" name="id" value="'.$id.'">';

print '<div class="fichecenter">';
print '<table class="border" width="100%">';

print '<tr><td>'.$langs->trans("DateStart").'</td><td align=center>';
print $form->select_date($object->date_start, 'dateo', 0, 0, '', "dateo");
print '</td></tr>'."\n";


print '<tr><th class="titlefield">'.$langs->trans("Day").'</th>';
print '<th class="titlefield">'.$langs->trans("Morning").'</th>';
print '<th class="titlefield">'.$langs->trans("Afternoon").'</th>';
print '<th class="titlefield">'.$langs->trans("ClosedDay").'</th>';
print '</tr>';

print '<tr><td>'.$langs->trans("Monday").'</td>';
print '</td><td align=center>';
print $form->select_duration('monday_am', $daily->monday_am, 0);
print '</td><td align=center>';
print $form->select_duration('monday_pm', $daily->monday_pm, 0);
print '</td><td align=center>';
print '<input type=checkbox name=monday_closeday ';
print ($daily->monday_closeday == 1?" checked ":"").' value=1>';
print '</td></tr>';

print '<tr><td>'.$langs->trans("Tuesday").'</td>';
print '</td><td align=center>';
print $form->select_duration('tuesday_am', $daily->tuesday_am, 0);
print '</td><td align=center>';
print $form->select_duration('tuesday_pm', $daily->tuesday_pm, 0);
print '</td><td align=center>';
print '<input type=checkbox name=tuesday_closeday ';
print ($daily->tuesday_closeday == 1?" checked ":"").' value=1>';
print '</td></tr>';

print '<tr><td>'.$langs->trans("Wednesday").'</td>';
print '</td><td align=center>';
print $form->select_duration('wednesday_am', $daily->wednesday_am, 0);
print '</td><td align=center>';
print $form->select_duration('wednesday_pm', $daily->wednesday_pm, 0);
print '</td><td align=center>';
print '<input type=checkbox name=wednesday_closeday ';
print ($daily->wednesday_closeday == 1?" checked ":"").' value=1>';
print '</td></tr>';

print '<tr><td>'.$langs->trans("Thursday").'</td>';
print '</td><td align=center>';
print $form->select_duration('thursday_am', $daily->thursday_am, 0);
print '</td><td align=center>';
print $form->select_duration('thursday_pm', $daily->thursday_pm, 0);
print '</td><td align=center>';
print '<input type=checkbox name=thursday_closeday ';
print ($daily->thursday_closeday == 1?" checked ":"").' value=1>';
print '</td></tr>';

print '<tr><td>'.$langs->trans("Friday").'</td>';
print '</td><td align=center>';
print $form->select_duration('friday_am', $daily->friday_am, 0);
print '</td><td align=center>';
print $form->select_duration('friday_pm', $daily->friday_pm, 0);
print '</td><td align=center>';
print '<input type=checkbox name=friday_closeday ';
print ($daily->friday_closeday == 1?" checked ":"").' value=1>';
print '</td></tr>';

print '<tr><td>'.$langs->trans("Saturday").'</td>';
print '</td><td align=center>';
print $form->select_duration('saturday_am', $daily->saturday_am, 0);
print '</td><td align=center>';
print $form->select_duration('saturday_pm', $daily->saturday_pm, 0);
print '</td><td align=center>';
print '<input type=checkbox name=saturday_closeday ';
print ($daily->saturday_closeday == 1?" checked ":"").' value=1>';
print '</td></tr>';

print '<tr><td>'.$langs->trans("Sunday").'</td>';
print '</td><td align=center>';
print $form->select_duration('sunday_am', $daily->sunday_am, 0);
print '</td><td align=center>';
print $form->select_duration('sunday_pm', $daily->sunday_pm, 0);
print '</td><td align=center>';
print '<input type=checkbox name=sunday_closeday ';
print ($daily->sunday_closeday == 1?" checked ":"").' value=1>';
print '</td></tr>';

print "</table>\n";
print "</div>\n";
print '<br><center>';
print '<input type="submit" class="button" value="'.$langs->trans("Save").'">';
print '</center>';
print "</form>\n";

print "</div>\n";
print "<br>\n";

llxFooter();
$db->close();