 <?php
/* Copyright (C) 2017-2019		Charlene Benke		<charlie@patas-monkey.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *	\file	   htdocs/myschedule/userreporttime.php
 *  \ingroup	myschedule
 *  \brief	  report des temps passe (projet/intervention/factory
 */

$res=@include("../main.inc.php");					// For root directory
if (! $res && file_exists($_SERVER['DOCUMENT_ROOT']."main.inc.php"))
	$res=@include($_SERVER['DOCUMENT_ROOT']."main.inc.php"); // Use on dev env only
if (! $res) $res=@include("../../main.inc.php");		// For "custom" directory

require_once DOL_DOCUMENT_ROOT.'/core/class/html.formother.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/date.lib.php';

require_once DOL_DOCUMENT_ROOT.'/core/lib/usergroups.lib.php';
dol_include_once('/myschedule/core/lib/myschedule.lib.php');
dol_include_once('/myschedule/class/dailytime.class.php');


$id			= GETPOST('id', 'int');

// rcup des parametres d'affichages
if (GETPOST('datedebmonth', 'int'))
	$datedeb = dol_mktime(
					0, 0, 0,
					GETPOST('datedebmonth', 'int'),
					GETPOST('datedebday', 'int'),
					GETPOST('datedebyear', 'int')
	);
else
	$datedeb = dol_mktime(0, 0, 0, 1, 1, date('Y'));

if (GETPOST('datefinmonth', 'int'))
	$datefin = dol_mktime(
					0, 0, 0,
					GETPOST('datefinmonth', 'int'),
					GETPOST('datefinday', 'int'),
					GETPOST('datefinyear', 'int')
	);	
else
	$datefin = dol_mktime(0, 0, 0, date('m'), date('d'), date('Y'));

$displaymode =(GETPOST('displaymode') != '' ? GETPOST('displaymode', 'int'): 1);  // 0 week, 1 month, 2 trim, 3 years
$displayinfo =(GETPOST('displayinfo') != '' ? GETPOST('displayinfo', 'int'): 0);  
$formatdisplaymode =(GETPOST('formatdisplaymode') != '' ? GETPOST('formatdisplaymode'): 'allhourmin');  

$search_categthirdparty = GETPOST("search_categthirdparty", 'int');
$search_categproject = GETPOST("search_categproject", 'int');

if ($user->societe_id) $socid=$user->societe_id;

$langs->load("myschedule@myschedule");

/*
 * View
 */

llxHeader('', $langs->trans("UserCard"));

// Show user tabs
$object=new User($db);
$object->fetch($id);
$head = user_prepare_head($object);
$title = $langs->trans("User");
dol_fiche_head($head, 'reportschedule', $title, 0, 'user');

$linkback = '';

if ($user->rights->user->user->lire || $user->admin) {
	$linkback = '<a href="'.DOL_URL_ROOT.'/user/index.php">'.$langs->trans("BackToList").'</a>';
}

dol_banner_tab($object, 'id', $linkback, $user->rights->user->user->lire || $user->admin);

$formother=new FormOther($db);
$userStatic=new User($db);

print '<form method="POST" action="userreporttime.php?id='.$id.'">';
print '<input type="hidden" name="token" value="'.$_SESSION['newtoken'].'">';

print '<table border="0" width="100%" class="noborder">';

$moreforfilter='';
if (false) {
//if (! empty($conf->categorie->enabled)) {
	print "<tr class='liste_titre' ><td >".$langs->trans('Categories').'</td>';

	print "<td >".$langs->trans('Customers')."</td><td>";
	print $formother->select_categories("customer", $search_categthirdparty, 'search_categthirdparty', 1);
	// catgorie de projet uniquement depuis la V5
	
	if ((int) DOL_VERSION >= 5) {
		if (! empty($conf->projet->enabled)) {
			print "</td><td>";
			print $langs->trans('CategoriesProjects')."</td><td>";
			print $formother->select_categories("project", $search_categproject, 'search_categproject', 1);
		}
	}
	print "</td></tr>";
}

print "<tr class='liste_titre' ><td >".$langs->trans('PeriodFilter').'</td>';
print "<td >".$langs->trans('DateDebFilter'). '</td><td>';
print $form->select_date($datedeb, 'datedeb', 0, 0, '', "datedeb");
print "</td><td>";
print $langs->trans('DateFinFilter'). '</td><td>';
print $form->select_date($datefin, 'datefin', 0, 0, '', "datefin");
// pour inclure le jour de fin slectionn
$datefin=$datefin+3600*24;

print "</td>";
print "<td align=center rowspan=2><input class='button' type=submit value='".$langs->trans('Search')."'></td>";
print "</tr>";
print "<tr class='liste_titre' >";
print "<td >".$langs->trans('DisplayMode'). '</td><td>';
// day mode not yet ok '-1'=>$langs->trans('DayMode'),
$displaymodearray = array(	
				'0'=>$langs->trans('WeekMode'),
				'1'=>$langs->trans('MonthMode'),
				'2'=>$langs->trans('TrimMode'),
				'3'=>$langs->trans('YearMode')
);
print $form->selectarray(
				"displaymode", $displaymodearray, $displaymode, 
				0, 0, 0, '', 0, 0, 0, '', '', 1
);
print "</td><td>";

print $langs->trans('FormatDisplayMode').'</td>';
print '<td colspan=2>';
$formatdisplaymodearray = array(
				'all'=>$langs->trans('DateAndHour'),
				'allwithouthour'=>$langs->trans('DateOnly'),
				'allhourmin'=>$langs->trans('HourOnly')
);
print $form->selectarray(
				"formatdisplaymode", $formatdisplaymodearray, $formatdisplaymode, 
				0, 0, 0, '', 0, 0, 0, '', '', 1
);

//if (! empty($conf->projet->enabled))
//	print '<input type=checkbox name=includeproject checked>'.$langs->trans('includeProject').'<br>';
//if (! empty($conf->ficheinter->enabled))
//	print '<input type=checkbox name=includeintervention checked>'.$langs->trans('includeIntervention').'<br>';
//if (! empty($conf->global->MAIN_MODULE_FACTORY))
//	print '<input type=checkbox name=includefactory checked>'.$langs->trans('includeFactory').'<br>';
print '</td>';

print "</tr>";
print '</table>';
print '</form>';

// si il y a des enregs  voir
// dtermination des colonnes du tableau  partir de la priode et du regroupement
$yeardeb  = (int) date('Y', $datedeb);
$yearfin  = (int) date('Y', $datefin);

// rcup des heures hedbo habituel de la personne
$daily = new Dailytime($db);
$dailyUser = $daily->fetchArray($id);

switch($displaymode) {
	case -1 : // jour
		// dtermination de la semaine de dbut et de fin
		$elemdeb  = $datedeb;
		$elemfin  = $datefin;
		break;
		
	case 0 : // semaine
		// dtermination de la semaine de dbut et de fin
		$elemdeb  = (int) date('W', $datedeb);
		if ($elemdeb == 53) // pour les annes avec le 1er qui tombe la 53e semaine...
			$yeardeb = $yeardeb-1;
		$elemfin  = (int) date('W', $datefin);
		break;
	case 1 : // mois
		// dtermination de la semaine de dbut et de fin
		$elemdeb  = (int) date('n', $datedeb);
		$elemfin  = (int) date('n', $datefin);
		break;
	case 2 : // trimestre
		// dtermination de la semaine de dbut et de fin
		switch((int) date('n', $datedeb)) {
			case 1 :
			case 2 :
			case 3 :
				$elemdeb = 1;
				break;
			case 4 :
			case 5 :
			case 6 :
				$elemdeb = 2;
				break;
			case 7 :
			case 8 :
			case 9 :
				$elemdeb = 3;
				break;
			default :
				$elemdeb = 4;
		}
		// dtermination de la semaine de dbut et de fin
		switch((int) date('n', $datefin)) {
			case 1 :
			case 2 :
			case 3 :
				$elemfin = 1;
				break;
			case 4 :
			case 5 :
			case 6 :
				$elemfin = 2;
				break;
			case 7 :
			case 8 :
			case 9 :
				$elemfin = 3;
				break;
			default :
				$elemfin = 4;
		}
		break;
}

//print $yeardeb ."-". $elemdeb. "=>".$yearfin ."-". $elemfin;

print '<table class="liste" width="100%">';
print '<tr class="liste_titre">';
print '<th rowspan=2>'.$langs->trans("User").'</th>';
// on affiche les annes
for ($yearplage=$yeardeb; $yearplage <= $yearfin; $yearplage++) {
	if ($displaymode == 3)
		print '<th rowspan=2 align=center>'.$yearplage.'</th>';
	else {
		// dtermination du nombre colonne 
		if ($yearplage==$yeardeb)
			$elemplagedeb = $elemdeb;
		else
			$elemplagedeb = 1;
		if ($yearplage == $yearfin) 
			$elemplagefin = $elemfin;
		else	// sinon on termine selon
			switch($displaymode) {
				case -1: //jour
					// prvoir anne bisextile
					$elemplagefin= 365;
					break;

				case 0: //semaine
					$elemplagefin= 53;
					break;
				case 1: // mois
					$elemplagefin = 12;
					break;
				case 2: // trimestre
					$elemplagefin = 4;
					break;
				case 3: // anne
					$elemplagefin = 1;
					break;
			}
		$nbcol=$elemplagefin - $elemplagedeb +1;
		print '<th align=center colspan='.$nbcol.'>'.$yearplage.'</th>';
		// et le total de la ligne
	}
}
print '<th rowspan=2 valign=bottom align=right>'.$langs->trans("Total").'</th>';		
print '</tr>';
// puis les lements associs
print '<tr>';
for ($yearplage=$yeardeb; $yearplage <= $yearfin;$yearplage++) {
	// si on est sur l'anne de dpart on prend l'lment de dpart
	if ($yearplage==$yeardeb) 
		$elemplagedeb= $elemdeb;
	else	// sinon on commence par 1
		$elemplagedeb= 1;
	// si on est sur l'anne de fin on prend l'lment de fin
	if ($yearplage == $yearfin) 
		$elemplagefin = $elemfin;
	else	// sinon on termine selon
		switch($displaymode) {
			case -1: //jours
				$elemplagefin= 365;
				break;

			case 0: //semaine
				$elemplagefin= 53;
				break;
			case 1: // mois
				$elemplagefin = 12;
				break;
			case 2: // trimestre
				$elemplagefin = 4;
				break;
			case 3: // anne
				$elemplagefin = 1;
				break;
		}

	// et maintenant on boucle sur les lments
	for ($elemplage=$elemplagedeb; $elemplage <= $elemplagefin; $elemplage++) {
		if ($displaymode != 3)
			switch($displaymode) {
				case -1:
					print '<th align=right>'.date('d-M', mktime(0, 0, 0, $elemplage, 10)).'</th>';
					break;
				case 0: //semaine
					print '<th align=right>'.$elemplage.'</th>';
					break;
				case 1: // mois
					print '<th align=right>'.date('M', mktime(0, 0, 0, $elemplage, 10)).'</th>';
					break;
				case 2: // trimestre
					print '<th align=right>T-'.$elemplage.'</th>';
					break;
			}
	}
} 
print "</tr>\n";


// affichage des temps  raliser (activit par semaine)
// Attention  la date d'embauche de l'utilisateur

$var=!$var;
print "<tr ".$bc[$var].">";
print '<td>'.$langs->trans("TimeToMade").'</td>';
$totalLine=0;
// on boucle maintenant sur les lments
for ($yearplage=$yeardeb; $yearplage <= $yearfin;$yearplage++) {
	// si on est sur l'anne de dpart on prend l'lment de dpart
	if ($yearplage==$yeardeb) 
		$elemplagedeb= $elemdeb;
	else	// sinon on commence par 1
		$elemplagedeb= 1;
	// si on est sur l'anne de fin on prend l'lment de fin
	if ($yearplage == $yearfin) 
		$elemplagefin = $elemfin;
	else	// sinon on termine selon
		switch($displaymode) {
			case -1: //jour
				$elemplagefin= 365;
				break;

			case 0: //semaine
				$elemplagefin= 53;
				break;
			case 1: // mois
				$elemplagefin = 12;
				break;
			case 2: // trimestre
				$elemplagefin = 4;
				break;
			case 3: // anne
				$elemplagefin = 1;
				break;
		}
	
	// on dtermine les plages de date de slection
	$totalLine=0;

	for ($elemplage=$elemplagedeb; $elemplage <= $elemplagefin; $elemplage++) {
		$totalPlage=0;
		switch($displaymode) {

			case -1: // jour  dol_mktim (hrs,mins,sec, mois, jours, annes) 
				$jourDebut = dol_mktime(0, 0, 0, $elemplage, 1, $yearplage);
				$jourFin = $jourDebut;
				break;
			
			case 0: //semaine
				$timeStampPremierJanvier = strtotime($yearplage . '-01-01');
				$jourPremierJanvier = date('w', $timeStampPremierJanvier);			// minuscule
				$numSemainePremierJanvier = date('W', $timeStampPremierJanvier);	// majuscule
				$decallage = ($numSemainePremierJanvier == 1) ? $elemplage - 1 : $elemplage;
				$timeStampDate = strtotime('+' . $decallage . ' weeks', $timeStampPremierJanvier);
				if ($jourPremierJanvier == 1) 
					$jourDebut = $timeStampDate;
				else
					$jourDebut = strtotime('last monday', $timeStampDate);

				$jourFin =  strtotime("last sunday +7 days ", $timeStampDate)+3600*24-1;

				break;

			case 1: // mois  dol_mktim (hrs,mins,sec, mois, jours, annes) 
				$jourDebut = dol_mktime(0, 0, 0, $elemplage, 1, $yearplage);
				if ($elemplage != 12)
					$jourFin = dol_mktime(0, 0, 0, $elemplage+1, 1, $yearplage);
				else
					$jourFin = dol_mktime(0, 0, 0, 1, 1, $yearplage+1);	
				
				$jourFin = strtotime(date('d-m-Y', strtotime("-1 day", $jourFin)));

				break;

			case 2: // trimestre
				$tbltrim = array(	1 =>array('01-01-'.$yearplage, '31-03-'.$yearplage),
									2=>array('01-04-'.$yearplage, '30-06-'.$yearplage),
									3=>array('01-07-'.$yearplage, '30-09-'.$yearplage),
									4=>array('01-10-'.$yearplage, '31-12-'.$yearplage)
								);
				$jourDebut = strtotime($tbltrim[$elemplage][0]);
				$jourFin = (strtotime($tbltrim[$elemplage][1])+3600*24-1);

				break;

			case 3 : // anne
				$jourDebut = dol_mktime(0, 0, 0, 1, 1, $yearplage);
				$jourFin = dol_mktime(0, 0, 0, 12, 31, $yearplage);	

				break;
		}
		//print $datedeb." > ".$jourDebut."//".$jourFin." = ".$datefin."<br>";
		if ($datedeb > $jourDebut)
			$jourDebut = $datedeb;
		if ($datefin < $jourFin)
			$jourFin = $datefin;

		
		$jourTraite = $jourDebut;
		while ($jourTraite < $jourFin) {
//			print date('d-m-y', $jourTraite)."-".date('w', $jourTraite)."<br>";
			$totalLine+=$dailyUser[date('w', $jourTraite)];
			$totalPlage+=$dailyUser[date('w', $jourTraite)];

			$jourTraite = strtotime(date('d-m-Y', strtotime("+1 day", $jourTraite)));
		}

		// et on affiche le rsultat
		print "<td align=right>".convertSecondToTime($totalPlage, $formatdisplaymode, ($formatdisplaymode=="allhourmin"?86400:28800))."</td>";
	}
}



print '<td align=right>';
print convertSecondToTime($totalLine, $formatdisplaymode, ($formatdisplaymode=="allhourmin"?86400:28800));
print '</td>';
print '</tr>';

// affichage des temps prvue (table projet_task_schedule)
$var=!$var;
print "<tr ".$bc[$var].">";
print '<td>'.$langs->trans("TimePlanned").'</td>';
$totalLine=0;
// on boucle maintenant sur les lments
for ($yearplage=$yeardeb; $yearplage <= $yearfin;$yearplage++) {
	// si on est sur l'anne de dpart on prend l'lment de dpart
	if ($yearplage==$yeardeb) 
		$elemplagedeb= $elemdeb;
	else	// sinon on commence par 1
		$elemplagedeb= 1;
	// si on est sur l'anne de fin on prend l'lment de fin
	if ($yearplage == $yearfin) 
		$elemplagefin = $elemfin;
	else	// sinon on termine selon
		switch($displaymode) {
			case -1: //semaine
				$elemplagefin= 365;
				break;

			case 0: //semaine
				$elemplagefin= 53;
				break;
			case 1: // mois
				$elemplagefin = 12;
				break;
			case 2: // trimestre
				$elemplagefin = 4;
				break;
			case 3: // anne
				$elemplagefin = 1;
				break;
		}
	
	// on dtermine les plages de date de slection
	for ($elemplage=$elemplagedeb; $elemplage <= $elemplagefin; $elemplage++) {
		switch($displaymode) {
			case 0: //semaine
				$timeStampPremierJanvier = strtotime($yearplage . '-01-01');
				$jourPremierJanvier = date('w', $timeStampPremierJanvier);			// minuscule
				$numSemainePremierJanvier = date('W', $timeStampPremierJanvier);	// majuscule
				$decallage = ($numSemainePremierJanvier == 1) ? $elemplage - 1 : $elemplage;
				$timeStampDate = strtotime('+' . $decallage . ' weeks', $timeStampPremierJanvier);
				if ($jourPremierJanvier == 1) 
					$jourDebut = $timeStampDate;
				else
					$jourDebut = strtotime('last monday', $timeStampDate);

				$jourFin =  strtotime("last sunday +7 days ", $timeStampDate)+3600*24-1;
				break;

			case 1: // mois  dol_mktim (hrs, mins, sec, mois, jours, annes) 
				$jourDebut = dol_mktime(0, 0, 0, $elemplage, 1, $yearplage);
				if ($elemplage != 12)
					$jourFin = dol_mktime(0, 0, 0, $elemplage+1, 1, $yearplage);
				else
					$jourFin = dol_mktime(0, 0, 0, 1, 1, $yearplage+1);
				$jourFin = strtotime(date('d-m-Y', strtotime("-1 day", $jourFin)))+3600*24-1;
				break;

			case 2: // trimestre
				$tbltrim = array(	1 =>array('01-01-'.$yearplage, '31-03-'.$yearplage),
									2=>array('01-04-'.$yearplage, '30-06-'.$yearplage),
									3=>array('01-07-'.$yearplage, '30-09-'.$yearplage),
									4=>array('01-10-'.$yearplage, '31-12-'.$yearplage)
								);
				$jourDebut=strtotime($tbltrim[$elemplage][0]);
				$jourFin=strtotime($tbltrim[$elemplage][1]+3600*24-1);

				break;

			case 3 : // anne
				$jourDebut = dol_mktime(0, 0, 0, 1, 1, $yearplage);
				$jourFin = dol_mktime(0, 0, 0, 12, 31, $yearplage)+3600*24-1;	
				break;
		}
		//print $datedeb." > ".$jourDebut."//".$jourFin." = ".$datefin."<br>";
		if ($datedeb > $jourDebut)
			$jourDebut = $datedeb;
		if ($datefin < $jourFin)
			$jourFin = $datefin;

		$sqldate = " AND task_date BETWEEN '".$db->idate($jourDebut)."'";
		$sqldate.= "  AND '".$db->idate($jourFin)."'";

		// la requete pour rcuprer les valeurs
		$sql = "SELECT count(rowid) as nbelem, count(fk_task) as nbtask, sum(task_duration) as total";
		$sql.= " FROM ".MAIN_DB_PREFIX."projet_task_schedule as ptt";
		$sql.= " WHERE fk_user = ".$id;

		// commun au type de requete
		$sql.=$sqldate;

		print "<td align=right>";

		$result = $db->query($sql);
		if ($result) {
				$obj = $db->fetch_object($result);
				if ($obj->nbelem > 0) {
					print convertSecondToTime($obj->total, $formatdisplaymode, ($formatdisplaymode=="allhourmin"?86400:28800));

					$totalLine+=$obj->total;
				}
		}
		print "</td>";
	}
}
print '<td align=right>';
print convertSecondToTime($totalLine, $formatdisplaymode, ($formatdisplaymode=="allhourmin"?86400:28800));
print '</td>';
print '</tr>';


// affichage des temps prvue (table projet_task_shedule)
$var=!$var;
print "<tr ".$bc[$var].">";
print '<td>'.$langs->trans("TimeMade").'</td>';
$totalLine=0;
// on boucle maintenant sur les lments
for ($yearplage=$yeardeb; $yearplage <= $yearfin;$yearplage++) {
	// si on est sur l'anne de dpart on prend l'lment de dpart
	if ($yearplage==$yeardeb) 
		$elemplagedeb= $elemdeb;
	else	// sinon on commence par 1
		$elemplagedeb= 1;
	// si on est sur l'anne de fin on prend l'lment de fin
	if ($yearplage == $yearfin) 
		$elemplagefin = $elemfin;
	else	// sinon on termine selon
		switch($displaymode) {
			case 0: //semaine
				$elemplagefin= 53;
				break;
			case 1: // mois
				$elemplagefin = 12;
				break;
			case 2: // trimestre
				$elemplagefin = 4;
				break;
			case 3: // anne
				$elemplagefin = 1;
				break;
		}
	
	// on dtermine les plages de date de slection
	for ($elemplage=$elemplagedeb; $elemplage <= $elemplagefin; $elemplage++) {
		switch($displaymode) {
			case 0: //semaine
				$timeStampPremierJanvier = strtotime($yearplage . '-01-01');
				$jourPremierJanvier = date('w', $timeStampPremierJanvier);			// minuscule
				$numSemainePremierJanvier = date('W', $timeStampPremierJanvier);	// majuscule
				$decallage = ($numSemainePremierJanvier == 1) ? $elemplage - 1 : $elemplage;
				$timeStampDate = strtotime('+' . $decallage . ' weeks', $timeStampPremierJanvier);
				if ($jourPremierJanvier == 1) 
					$jourDebut = $timeStampDate;
				else
					$jourDebut = strtotime('last monday', $timeStampDate);

				$jourFin =  strtotime("last sunday +7 days ", $timeStampDate);
				//print $datedeb." > ".$jourDebut."//".$jourFin." = ".$datefin."<br>";
				if ($datedeb > $jourDebut)
					$jourDebut = $datedeb;
				if ($datefin < $jourFin)
					$jourFin = $datefin;

				$sqldate = " AND task_date BETWEEN '".$db->idate($jourDebut)."'";
				$sqldate.= " AND '".$db->idate($jourFin)."'";
				break;

			case 1: // mois  dol_mktim (hrs,mins,sec, mois, jours, annes) 
				$jourDebut = dol_mktime(0, 0, 0, $elemplage, 1, $yearplage);
				if ($elemplage != 12)
					$jourFin = dol_mktime(0, 0, 0, $elemplage+1, 1, $yearplage);
				else
					$jourFin = dol_mktime(0, 0, 0, 1, 1, $yearplage+1);	
				$jourFin = strtotime(date('d-m-Y', strtotime("-1 day", $jourFin)));

				//print $datedeb." > ".$jourDebut."//".$jourFin." = ".$datefin."<br>";
				if ($datedeb > $jourDebut)
					$jourDebut = $datedeb;
				if ($datefin < $jourFin)
					$jourFin = $datefin;

				$sqldate = " AND task_date BETWEEN '".$db->idate($jourDebut)."'";
				$sqldate.= " AND '".$db->idate($jourFin)."'";
				break;

			case 2: // trimestre
				$tbltrim = array(	1 =>array('01-01-'.$yearplage, '31-03-'.$yearplage),
									2=>array('01-04-'.$yearplage, '30-06-'.$yearplage),
									3=>array('01-07-'.$yearplage, '30-09-'.$yearplage),
									4=>array('01-10-'.$yearplage, '31-12-'.$yearplage)
								);

				//print $datedeb." > ".$jourDebut."//".$jourFin." = ".$datefin."<br>";
				if ($datedeb > $jourDebut)
					$jourDebut = $datedeb;
				if ($datefin < $jourFin)
					$jourFin = $datefin;

				$sqldate = " AND task_date BETWEEN '".$db->idate(strtotime($tbltrim[$elemplage][0]))."'";
				$sqldate.= " AND '".$db->idate(strtotime($tbltrim[$elemplage][1])+3600*24-1)."'";
				break;

			case 3 : // anne
				$jourDebut = dol_mktime(0, 0, 0, 1, 1, $yearplage);
				$jourFin = dol_mktime(0, 0, 0, 12, 31, $yearplage);	

				//print $datedeb." > ".$jourDebut."//".$jourFin." = ".$datefin."<br>";
				if ($datedeb > $jourDebut)
					$jourDebut = $datedeb;
				if ($datefin < $jourFin)
					$jourFin = $datefin;

				$sqldate = " AND task_date BETWEEN '".$db->idate($jourDebut)."'";
				$sqldate.= "  AND '".$db->idate($jourFin+3600*24-1)."'";
				break;
		}

		// la requete pour rcuprer les valeurs
		$sql = "SELECT count(rowid) as nbelem, count(fk_task) as nbtask, sum(task_duration) as total";
		$sql.= " FROM ".MAIN_DB_PREFIX."projet_task_time as ptt";
		$sql.= " WHERE fk_user = ".$id;

		// commun au type de requete
		$sql.=$sqldate;

		print "<td align=right>";

		$result = $db->query($sql);
		if ($result) {
				$obj = $db->fetch_object($result);
				if ($obj->nbelem > 0) {
					print convertSecondToTime($obj->total, $formatdisplaymode, ($formatdisplaymode=="allhourmin"?86400:28800));

					$totalLine+=$obj->total;
				}
		}
		print "</td>";
	}
}
print '<td align=right>';
print convertSecondToTime($totalLine, $formatdisplaymode, ($formatdisplaymode=="allhourmin"?86400:28800));
print '</td>';

print '</tr>';

// affichage des temps manquants
$var=!$var;
print "<tr ".$bc[$var].">";
print '<td>'.$langs->trans("MissingTime").'</td>';
$totalLine=0;

// on boucle maintenant sur les lments, les annes puis les lments (semaine, mois, ...)
for ($yearplage=$yeardeb; $yearplage <= $yearfin;$yearplage++) {
	// si on est sur l'anne de dpart on prend l'lment de dpart
	if ($yearplage==$yeardeb) 
		$elemplagedeb= $elemdeb;
	else	// sinon on commence par 1
		$elemplagedeb= 1;
	// si on est sur l'anne de fin on prend l'lment de fin
	if ($yearplage == $yearfin) 
		$elemplagefin = $elemfin;
	else	// sinon on termine selon
		switch($displaymode) {
			case 0: //semaine
				$elemplagefin= 53;
				break;
			case 1: // mois
				$elemplagefin = 12;
				break;
			case 2: // trimestre
				$elemplagefin = 4;
				break;
			case 3: // anne
				$elemplagefin = 1;
				break;
		}
	
	// on dtermine les plages de date de slection
	for ($elemplage=$elemplagedeb; $elemplage <= $elemplagefin; $elemplage++) {
		switch($displaymode) {
			case 0: //semaine
				$timeStampPremierJanvier = dol_mktime(0, 0, 0, 1, 1, $yearplage);
				$jourPremierJanvier = date('w', $timeStampPremierJanvier);			// minuscule
				$numSemainePremierJanvier = date('W', $timeStampPremierJanvier);	// majuscule

				$decallage = ($numSemainePremierJanvier == 1) ? $elemplage - 1 : $elemplage;
				$timeStampDate = strtotime('+' . $decallage . ' weeks', $timeStampPremierJanvier);

				if ($jourPremierJanvier == 1) 
					$jourDebut = $timeStampDate;
				else
					$jourDebut = strtotime('last monday', $timeStampDate);

				$jourFin =  strtotime("last sunday +7 day", $timeStampDate);
				break;

			case 1: // mois  dol_mktime (hrs,mins,sec, mois, jours, annes) 
				$jourDebut = dol_mktime(0, 0, 0, $elemplage, 1, $yearplage);
				if ($elemplage != 12)
					$jourFin = dol_mktime(0, 0, 0, $elemplage+1, 1, $yearplage);
				else
					$jourFin = dol_mktime(0, 0, 0, 1, 1, $yearplage+1);	
				$jourFin = strtotime(date('d-m-Y', strtotime("-1 day", $jourFin)));
				break;

			case 2: // trimestre
				$tbltrim = array(	1 =>array('01-01-'.$yearplage, '31-03-'.$yearplage),
									2=>array('01-04-'.$yearplage, '30-06-'.$yearplage),
									3=>array('01-07-'.$yearplage, '30-09-'.$yearplage),
									4=>array('01-10-'.$yearplage, '31-12-'.$yearplage)
								);

				$jourDebut=strtotime($tbltrim[$elemplage][0]);
				$jourFin=strtotime($tbltrim[$elemplage][1]+3600*24-1);
				break;

			case 3 : // anne
				$jourDebut = dol_mktime(0, 0, 0, 1, 1, $yearplage);
				$jourFin = dol_mktime(0, 0, 0, 12, 31, $yearplage)+3600*24-1;	
				break;
		}

		//print $datedeb." > ".$jourDebut."//".$jourFin." = ".$datefin."<br>";
		if ($datedeb > $jourDebut)
			$jourDebut = $datedeb;
		if ($datefin < $jourFin)
			$jourFin = $datefin;

		$sqldate = " AND task_date BETWEEN '".$db->idate($jourDebut)."'";
		$sqldate.= "  AND '".$db->idate($jourFin)."'";


		// la requete pour rcuprer les valeurs
		$sql = "SELECT task_date, date_format( task_date, '%w') as numjour, sum(task_duration) as total";
		$sql.= " FROM ".MAIN_DB_PREFIX."projet_task_time as ptt";
		$sql.= " WHERE fk_user = ".$id;
		// commun au type de requete
		$sql.= $sqldate;
		$sql.= " GROUP BY task_date, date_format( task_date, '%w')";

		print "<td align=right>";
//print $sql."<br>";
		$result = $db->query($sql);
		if ($result) {
			$i = 0;
			$num = $db->num_rows($result);

			$missingtimeperiod=0;
			while ($i < $num) {
				$obj = $db->fetch_object($result);
//				print $obj->task_date."- ".$obj->numjour.">> ".($obj->total - $dailyUser[$obj->numjour])."<br>";
				if ($dailyUser[$obj->numjour]  - $obj->total > 0)
					$missingtimeperiod+= ($dailyUser[$obj->numjour] - $obj->total);
				$i++;
			}
			if ($missingtimeperiod > 0)
				print convertSecondToTime($missingtimeperiod, $formatdisplaymode, ($formatdisplaymode=="allhourmin"?86400:28800));
			$totalLine+=$missingtimeperiod;
		}
		print "</td>";
	}
}
print '<td align=right>';
print convertSecondToTime($totalLine, $formatdisplaymode, ($formatdisplaymode=="allhourmin"?86400:28800));
print '</td>';
print '</tr>';



// affichage des temps heures supp
$var=!$var;
print "<tr ".$bc[$var].">";
print '<td>'.$langs->trans("OverTime").'</td>';
$totalLine=0;

// on boucle maintenant sur les lments, les annes puis les lments (semaine, mois, ...)
for ($yearplage=$yeardeb; $yearplage <= $yearfin;$yearplage++) {
	// si on est sur l'anne de dpart on prend l'lment de dpart
	if ($yearplage==$yeardeb) 
		$elemplagedeb= $elemdeb;
	else	// sinon on commence par 1
		$elemplagedeb= 1;
	// si on est sur l'anne de fin on prend l'lment de fin
	if ($yearplage == $yearfin) 
		$elemplagefin = $elemfin;
	else	// sinon on termine selon
		switch($displaymode) {
			case 0: //semaine
				$elemplagefin= 53;
				break;
			case 1: // mois
				$elemplagefin = 12;
				break;
			case 2: // trimestre
				$elemplagefin = 4;
				break;
			case 3: // anne
				$elemplagefin = 1;
				break;
		}
	
	// on dtermine les plages de date de slection
	for ($elemplage=$elemplagedeb; $elemplage <= $elemplagefin; $elemplage++) {
		switch($displaymode) {
			case 0: //semaine
				$timeStampPremierJanvier = dol_mktime(0, 0, 0, 1, 1, $yearplage);
				$jourPremierJanvier = date('w', $timeStampPremierJanvier);			// minuscule
				$numSemainePremierJanvier = date('W', $timeStampPremierJanvier);	// majuscule

				$decallage = ($numSemainePremierJanvier == 1) ? $elemplage - 1 : $elemplage;
				$timeStampDate = strtotime('+' . $decallage . ' weeks', $timeStampPremierJanvier);

				if ($jourPremierJanvier == 1) 
					$jourDebut = $timeStampDate;
				else
					$jourDebut = strtotime('last monday', $timeStampDate);

				$jourFin =  strtotime("last sunday +7 day", $timeStampDate);
				break;

			case 1: // mois  dol_mktime (hrs,mins,sec, mois, jours, annes) 
				$jourDebut = dol_mktime(0, 0, 0, $elemplage, 1, $yearplage);
				if ($elemplage != 12)
					$jourFin = dol_mktime(0, 0, 0, $elemplage+1, 1, $yearplage);
				else
					$jourFin = dol_mktime(0, 0, 0, 1, 1, $yearplage+1);	
				$jourFin = strtotime(date('d-m-Y', strtotime("-1 day", $jourFin)));
				break;

			case 2: // trimestre
				$tbltrim = array(	1 =>array('01-01-'.$yearplage, '31-03-'.$yearplage),
									2=>array('01-04-'.$yearplage, '30-06-'.$yearplage),
									3=>array('01-07-'.$yearplage, '30-09-'.$yearplage),
									4=>array('01-10-'.$yearplage, '31-12-'.$yearplage)
								);

				$jourDebut=strtotime($tbltrim[$elemplage][0]);
				$jourFin=strtotime($tbltrim[$elemplage][1]+3600*24-1);
				break;

			case 3 : // anne
				$jourDebut = dol_mktime(0, 0, 0, 1, 1, $yearplage);
				$jourFin = dol_mktime(0, 0, 0, 12, 31, $yearplage)+3600*24-1;	
				break;
		}
		//print $datedeb." > ".$jourDebut."//".$jourFin." = ".$datefin."<br>";
		if ($datedeb > $jourDebut)
			$jourDebut = $datedeb;
		if ($datefin < $jourFin)
			$jourFin = $datefin;

		$sqldate = " AND task_date BETWEEN '".$db->idate($jourDebut)."'";
		$sqldate.= "  AND '".$db->idate($jourFin)."'";


		// la requete pour rcuprer les valeurs
		$sql = "SELECT task_date, date_format( task_date, '%w') as numjour, sum(task_duration) as total";
		$sql.= " FROM ".MAIN_DB_PREFIX."projet_task_time as ptt";
		$sql.= " WHERE fk_user = ".$id;
		// commun au type de requete
		$sql.= $sqldate;
		$sql.= " GROUP BY task_date, date_format( task_date, '%w')";

		print "<td align=right>";
//print $sql."<br>";
		$result = $db->query($sql);
		if ($result) {
			$i = 0;
			$num = $db->num_rows($result);

			$overtimeperiod=0;
			while ($i < $num) {
				$obj = $db->fetch_object($result);
//				print $obj->task_date."- ".$obj->numjour."- ".$obj->total."- ".$dailyUser[$obj->numjour]."<br>";
				if ($obj->total - $dailyUser[$obj->numjour] > 0)
					$overtimeperiod+= ($obj->total - $dailyUser[$obj->numjour]);
				$i++;
			}
			if ($overtimeperiod > 0)
				print convertSecondToTime($overtimeperiod, $formatdisplaymode, ($formatdisplaymode=="allhourmin"?86400:28800));
			$totalLine+=$overtimeperiod;
		}
		print "</td>";
	}
}
print '<td align=right>';
print convertSecondToTime($totalLine, $formatdisplaymode, ($formatdisplaymode=="allhourmin"?86400:28800));
print '</td>';
print '</tr>';



// affichage des congs regroup par type (table llx_holliday et llx_c_holliday_types )
$sql="SELECT distinct cht.rowid, cht.label ";
$sql.= " FROM ".MAIN_DB_PREFIX."c_holiday_types as cht, ".MAIN_DB_PREFIX."holiday as h";
// uniquement les types de congs du collaborateur
$sql.= " WHERE h.fk_user=".$id;
$sql.= " AND h.fk_type = cht.rowid";
// sur la priode considre (datedeb, datefin)
$sql.= " AND ( h.date_debut between ". $db->idate($datedeb)." and ".$db->idate($datefin);
$sql.= " OR h.date_fin between ". $db->idate($datedeb)." and ".$db->idate($datefin).")";

$resql = $db->query($sql);
if ($resql) { 
	$num = $db->num_rows($resql);
	$i=0;
	while ($i < $num) {
		$obj = $db->fetch_object($resql);
		$var=!$var;
		print "<tr ".$bc[$var].">";
		print '<td><b>'.$obj->label.'</b></td>';
		$totalLine=0;
		// on rcupre les temps
		$totalPlage=0;
		// on boucle maintenant sur les lments, les annes puis les lments (semaine, mois, ...)
		for ($yearplage=$yeardeb; $yearplage <= $yearfin;$yearplage++) {
			// si on est sur l'anne de dpart on prend l'lment de dpart
			if ($yearplage==$yeardeb) 
				$elemplagedeb= $elemdeb;
			else	// sinon on commence par 1
				$elemplagedeb= 1;
			// si on est sur l'anne de fin on prend l'lment de fin
			if ($yearplage == $yearfin) 
				$elemplagefin = $elemfin;
			else	// sinon on termine selon
				switch($displaymode) {
					case 0: //semaine
						$elemplagefin= 53;
						break;
					case 1: // mois
						$elemplagefin = 12;
						break;
					case 2: // trimestre
						$elemplagefin = 4;
						break;
					case 3: // anne
						$elemplagefin = 1;
						break;
				}
			$totalLine=0;
			$totalPlage=0;
				
			// on dtermine les plages de date de slection
			for ($elemplage=$elemplagedeb; $elemplage <= $elemplagefin; $elemplage++) {
				switch($displaymode) {
					case 0: //semaine
						$timeStampPremierJanvier = dol_mktime(0, 0, 0, 1, 1, $yearplage);
						$jourPremierJanvier = date('w', $timeStampPremierJanvier);			// minuscule
						$numSemainePremierJanvier = date('W', $timeStampPremierJanvier);	// majuscule

						$decallage = ($numSemainePremierJanvier == 1) ? $elemplage - 1 : $elemplage;
						$timeStampDate = strtotime('+' . $decallage . ' weeks', $timeStampPremierJanvier);

						if ($jourPremierJanvier == 1) 
							$jourDebut = $timeStampDate;
						else
							$jourDebut = strtotime('last monday', $timeStampDate);

						$jourFin =  strtotime("last sunday +7 day", $timeStampDate);

						break;

					case 1: // mois  dol_mktime (hrs,mins,sec, mois, jours, annes) 
						$jourDebut = dol_mktime(0, 0, 0, $elemplage, 1, $yearplage);
						if ($elemplage != 12)
							$jourFin = dol_mktime(0, 0, 0, $elemplage+1, 1, $yearplage);
						else
							$jourFin = dol_mktime(0, 0, 0, 1, 1, $yearplage+1);	
						$jourFin = strtotime(date('d-m-Y', strtotime("-1 day", $jourFin)));

						break;

					case 2: // trimestre
						$tbltrim = array(	1 =>array('01-01-'.$yearplage, '31-03-'.$yearplage),
											2=>array('01-04-'.$yearplage, '30-06-'.$yearplage),
											3=>array('01-07-'.$yearplage, '30-09-'.$yearplage),
											4=>array('01-10-'.$yearplage, '31-12-'.$yearplage)
										);
						$jourDebut=strtotime($tbltrim[$elemplage][0]);
						$jourFin=strtotime($tbltrim[$elemplage][1]+3600*24-1);

						break;

					case 3 : // anne
						$jourDebut = dol_mktime(0, 0, 0, 1, 1, $yearplage);
						$jourFin = dol_mktime(0, 0, 0, 12, 31, $yearplage);	

						break;
				}
				
				//print $datedeb." > ".$jourDebut."//".$jourFin." = ".$datefin."<br>";
				if ($datedeb > $jourDebut)
					$jourDebut = $datedeb;
				if ($datefin < $jourFin)
					$jourFin = $datefin;

				// Liste des congs sur la priode (table llx_holliday)
				$sql="SELECT h.date_debut, h.date_fin, halfday ";
				$sql.= " FROM ".MAIN_DB_PREFIX."holiday as h";
				// uniquement les types de congs du collaborateur
				$sql.= " WHERE h.fk_user=".$id;
				$sql.= " AND h.fk_type = ".$obj->rowid;
				// sur la priode considre (datedeb, datefin)
				$sql.= " AND ( h.date_debut between ". $db->idate($jourDebut)." AND ".$db->idate($jourFin);
				$sql.= " OR h.date_fin between ". $db->idate($jourDebut)." AND ". $db->idate($jourFin).")";
				$resconge = $db->query($sql);
//				print $sql.'<br>';
				
				if ($resconge) { 
					$numconge = $db->num_rows($resconge);
					$j=0;
					$totalLine=0;
					while ($j < $numconge) {
						$objconges = $db->fetch_object($resconge);
						$jourTraite = $objconges->date_debut;

						while ($db->idate($jourTraite) <= $db->idate($objconges->date_fin)) {
							$datetraite = new DateTime($jourTraite);

//							print $jourTraite.">>"." ".date('w', strtotime($jourTraite))." ".$dailyUser[date('w', strtotime($jourTraite))].'<br>';
							$totalLine+=$dailyUser[date('w', strtotime($jourTraite))];
							$totalPlage+=$dailyUser[date('w', strtotime($jourTraite))];
							
							// on passe au jour suivant
							$datetraite->add(new DateInterval('P1D'));
							$jourTraite = $datetraite->format('Y-m-d');
						}
						$j++;
					}
					print "<td align=right>";
					if ($totalLine > 0)
						print convertSecondToTime($totalLine, $formatdisplaymode, ($formatdisplaymode=="allhourmin"?86400:28800));
					print "</td>";
				}
			}
			print '<td align=right>';
			if ($totalPlage > 0)
				print convertSecondToTime($totalPlage, $formatdisplaymode, ($formatdisplaymode=="allhourmin"?86400:28800));
			print '</td>';
			print "</tr>";
		}

		$i++;
	}
}

print '</table>';

llxFooter();
$db->close();