<?php

require_once DOL_DOCUMENT_ROOT . '/custom/fichajes/lib/fichajes.lib.php';

class Fichaje extends CommonObject
{
    /**
     * @var string ID to identify managed object
     */
    public $element = "fichaje";

    /**
     * @var string Name of table without prefix where object is stored
     */
    public $table_element = "fichaje_log";

    public $date;

    public $userid;

    public $geoposition;

    public $type;

    public $description;

    /**
     *    Constructor
     *
     *  @param        DoliDB        $db      Database handler
     */
    public function __construct($db)
    {
        global $conf;
        $this->db = $db;
    }

    public function insert()
    {
        global $conf;

        $error = 0;

        $this->db->begin();

        if ($this->type == "Entrada" && $conf->global->FICHAJES_AUTO_FICHAJE_SALIDA) {
            // Comprobar si el último fue salida, y si no lo fue, autoasignarlo con la hora de salida
            $sql = "SELECT fl1.rowid, fl1.tms FROM
                    (SELECT fl.rowid, fl.tms, fl.mov_type FROM " . MAIN_DB_PREFIX . "fichajes_log fl WHERE fl.user_id = " . $this->userid . " AND fl.mov_type = 'Entrada') as fl1
                    LEFT JOIN
                    (SELECT f2.rowid, f2.tms, f2.mov_type FROM " . MAIN_DB_PREFIX . "fichajes_log f2 WHERE f2.user_id = " . $this->userid . " AND f2.mov_type = 'Salida') as fl2 ON DATE(fl1.tms) = DATE(fl2.tms)
                    WHERE fl2.tms IS NULL";
            $resql = $this->db->query($sql);
            if ($resql) {
                $nrows = $this->db->num_rows($resql);
                if ($nrows > 0) {
                    $obj = $this->db->fetch_object($resql);

                    $sql2 = "SELECT leavetime FROM " . MAIN_DB_PREFIX . "fichajes_timetable WHERE day = " . getDayOfWeekFromDate($obj->tms);
                    $resql2 = $this->db->query($sql2);
                    if ($resql2) {
                        $nrows2 = $this->db->num_rows($resql2);
                        if ($nrows2 > 0) {
                            $obj2 = $this->db->fetch_object($resql2);

                            $leaveDate = date("Y-m-d", strtotime($obj->tms)) . " " . $obj2->leavetime;

                            $fichaje = new Fichaje($this->db);
                            $fichaje->geoposition = "";
                            $fichaje->date = $leaveDate;
                            $fichaje->userid = $this->userid;
                            $fichaje->type = "Salida";
                            $fichaje->insert();
                        }
                    }
                }
            }
        }

        if (!$conf->global->FICHAJES_GEOLOCALIZACION) {
            $this->geoposition = "";
        }

        $sql = "INSERT INTO " . MAIN_DB_PREFIX . "fichajes_log (user_id, tms, mov_type, description, geoposition)
                VALUES (" . $this->userid . ", '" . $this->date . "', '" . $this->type . "', '" . $this->db->escape($this->description) . "', '" . $this->geoposition . "')";

        dol_syslog(get_class($this) . "::create", LOG_DEBUG);
        $resql = $this->db->query($sql);
        if ($resql) {
            $this->db->commit();
        } else {
            $this->db->rollback();
        }
    }
}
